/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.compat;

import com.commonsense.android.kotlin.base.compat.SSLContextProtocols;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J,\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0015\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/commonsense/android/kotlin/base/compat/SSLSocketFactoryCompat;", "Ljavax/net/ssl/SSLSocketFactory;", "()V", "factory", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "s", "", "autoClose", "", "localHost", "enableTLSOnSocket", "socket", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "base_release"})
public final class SSLSocketFactoryCompat
extends SSLSocketFactory {
    private final SSLSocketFactory factory;

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.factory.getSupportedCipherSuites();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"factory.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.factory.getDefaultCipherSuites();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"factory.defaultCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable Socket s, @Nullable String host, int port, boolean autoClose) {
        Socket socket = this.factory.createSocket(s, host, port, autoClose);
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(s, host, port, autoClose)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, int port) {
        Socket socket = this.factory.createSocket(host, port);
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(host, port)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, int port, @Nullable InetAddress localHost, int localPort) {
        Socket socket = this.factory.createSocket(host, port, localHost, localPort);
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(hos\u2026rt, localHost, localPort)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress host, int port) {
        Socket socket = this.factory.createSocket(host, port);
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(host, port)");
        return this.enableTLSOnSocket(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress address, int port, @Nullable InetAddress localAddress, int localPort) {
        Socket socket = this.factory.createSocket(address, port, localAddress, localPort);
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(add\u2026 localAddress, localPort)");
        return this.enableTLSOnSocket(socket);
    }

    private final Socket enableTLSOnSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1.2"});
        }
        return socket;
    }

    public SSLSocketFactoryCompat() {
        SSLSocketFactory optFactory;
        SSLSocketFactory sSLSocketFactory = optFactory = SSLContextProtocols.TLSv12.createSocketFactory();
        if (sSLSocketFactory == null) {
            throw (Throwable)new RuntimeException("Cannot work with SSL / TLS when its not available.");
        }
        this.factory = sSLSocketFactory;
    }
}

