/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.extensions.collections;

import android.util.SparseArray;
import android.util.SparseIntArray;
import androidx.annotation.IntRange;
import com.commonsense.android.kotlin.base.algorithms.Comparing;
import com.commonsense.android.kotlin.base.debug.PrettyPrintKt;
import com.commonsense.android.kotlin.base.extensions.collections.SpareArrayExtensionsKt$WhenMappings;
import com.commonsense.android.kotlin.base.extensions.collections.SparseArrayEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a=\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001a\b\u0004\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0086\b\u001ak\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0001\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00032H\b\u0004\u0010\n\u001aB\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u0005j\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u000f`\u0010H\u0086\b\u001a7\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001c\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00120\u0014j\b\u0012\u0004\u0012\u0002H\u0002`\u0015H\u0086\b\u001af\u0010\u0016\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032K\u0010\u0013\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00120\u0017H\u0086\b\u001aQ\u0010\u001a\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000326\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00120\u0005H\u0086\b\u001a!\u0010\u001b\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0006H\u0086\b\u001a/\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u001d\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0006H\u0086\b\u001aI\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u00020\u00032\"\u0010!\u001a\u001e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H 0\u0014j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H `\"H\u0086\b\u001a'\u0010#\u001a\u00020\u0012*\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001d0\u001fH\u0086\b\u001a!\u0010#\u001a\u00020\u0012*\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060&H\u0086\b\u001a/\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00010\u001f\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00032\b\b\u0003\u0010(\u001a\u00020\u0006H\u0086\b\u001a\u0019\u0010)\u001a\u00020*\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0086\b*v\u0010+\u001a\u0004\b\u0000\u0010\t\u001a\u0004\b\u0001\u0010,\"2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H,0\u000522\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H,0\u0005\u00a8\u0006-"}, d2={"binarySearch", "Lcom/commonsense/android/kotlin/base/extensions/collections/SparseArrayEntry;", "E", "Landroid/util/SparseArray;", "compare", "Lkotlin/Function2;", "", "Lcom/commonsense/android/kotlin/base/algorithms/Comparing;", "findFirst", "T", "condition", "Lkotlin/ParameterName;", "name", "key", "item", "", "Lcom/commonsense/android/kotlin/base/extensions/collections/SparseArrayEntryMapper;", "forEach", "", "action", "Lkotlin/Function1;", "Lcom/commonsense/android/kotlin/base/FunctionUnit;", "forEachIndexed", "Lkotlin/Function3;", "value", "index", "forEachKeyValue", "isIndexValid", "keyValueAt", "Lkotlin/Pair;", "map", "", "U", "mapper", "Lcom/commonsense/android/kotlin/base/MapFunction;", "set", "Landroid/util/SparseIntArray;", "input", "", "toList", "maxKeyValue", "toPrettyString", "", "SparseArrayEntryMapper", "O", "base_release"})
public final class SpareArrayExtensionsKt {
    public static final void set(@NotNull SparseIntArray $this$set, @NotNull List<Pair<Integer, Integer>> input) {
        int $i$f$set = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$set, (String)"$this$set");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $this$set.clear();
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            $this$set.put(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
    }

    public static final void set(@NotNull SparseIntArray $this$set, @NotNull Map<Integer, Integer> input) {
        int $i$f$set = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$set, (String)"$this$set");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $this$set.clear();
        Map<Integer, Integer> $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        Map<Integer, Integer> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Integer, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> element$iv;
            Map.Entry<Integer, Integer> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$set.put(((Number)it.getKey()).intValue(), ((Number)it.getValue()).intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<SparseArrayEntry<T>> toList(@NotNull SparseArray<T> $this$toList, @IntRange(from=1L) int maxKeyValue) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        ArrayList list$iv;
        void $this$mapTo$iv$iv;
        int $i$f$toList = 0;
        Intrinsics.checkParameterIsNotNull($this$toList, (String)"$this$toList");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = $this$toList.keyAt((int)p1);
            collection.add(n2);
        }
        List mapped = (List)destination$iv$iv;
        if (maxKeyValue < Integer.MAX_VALUE) {
            Iterable $this$takeWhile$iv = mapped;
            boolean $i$f$takeWhile = false;
            list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                int it = ((Number)item$iv).intValue();
                boolean bl = false;
                if (!(it <= maxKeyValue)) break;
                list$iv.add(item$iv);
            }
            list = list$iv;
        } else {
            list = mapped;
        }
        ArrayList $this$mapNotNull$iv = (ArrayList)list;
        boolean $i$f$mapNotNull = false;
        list$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SparseArrayEntry<Object> sparseArrayEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int key = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ($this$toList.get(key) != null) {
                Object object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                sparseArrayEntry = new SparseArrayEntry<Object>(key, it);
            } else {
                sparseArrayEntry = null;
            }
            if (sparseArrayEntry == null) continue;
            SparseArrayEntry<Object> sparseArrayEntry2 = sparseArrayEntry;
            boolean bl6 = false;
            boolean bl7 = false;
            SparseArrayEntry<Object> it$iv$iv = sparseArrayEntry2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ List toList$default(SparseArray $this$toList, int maxKeyValue, int n, Object object) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        ArrayList list$iv;
        void $this$mapTo$iv$iv;
        if ((n & 1) != 0) {
            maxKeyValue = Integer.MAX_VALUE;
        }
        boolean $i$f$toList = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$toList, (String)"$this$toList");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n3 = $this$toList.keyAt((int)p1);
            collection.add(n3);
        }
        List mapped = (List)destination$iv$iv;
        if (maxKeyValue < Integer.MAX_VALUE) {
            Iterable $this$takeWhile$iv = mapped;
            boolean $i$f$takeWhile = false;
            list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                int it = ((Number)item$iv).intValue();
                boolean bl = false;
                if (!(it <= maxKeyValue)) break;
                list$iv.add(item$iv);
            }
            list = list$iv;
        } else {
            list = mapped;
        }
        ArrayList $this$mapNotNull$iv = (ArrayList)list;
        boolean $i$f$mapNotNull = false;
        list$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SparseArrayEntry<Object> sparseArrayEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int key = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ($this$toList.get(key) != null) {
                Object object2;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                sparseArrayEntry = new SparseArrayEntry<Object>(key, it);
            } else {
                sparseArrayEntry = null;
            }
            if (sparseArrayEntry == null) continue;
            SparseArrayEntry<Object> sparseArrayEntry2 = sparseArrayEntry;
            boolean bl6 = false;
            boolean bl7 = false;
            SparseArrayEntry<Object> it$iv$iv = sparseArrayEntry2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> SparseArrayEntry<T> findFirst(@NotNull SparseArray<T> $this$findFirst, @NotNull Function2<? super Integer, ? super T, Boolean> condition) {
        int $i$f$findFirst = 0;
        Intrinsics.checkParameterIsNotNull($this$findFirst, (String)"$this$findFirst");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        int size = $this$findFirst.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            int key = $this$findFirst.keyAt((int)i);
            Object item = $this$findFirst.get(key);
            if (((Boolean)condition.invoke((Object)key, item)).booleanValue()) {
                return new SparseArrayEntry<Object>(key, item);
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E, U> List<U> map(@NotNull SparseArray<E> $this$map, @NotNull Function1<? super E, ? extends U> mapper) {
        int $i$f$map = 0;
        Intrinsics.checkParameterIsNotNull($this$map, (String)"$this$map");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        SparseArray<E> $this$forEach$iv = $this$map;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.size();
        while (n < n2) {
            void i$iv;
            Object value$iv;
            Object it = value$iv = $this$forEach$iv.valueAt((int)i$iv);
            boolean bl5 = false;
            $this$apply.add(mapper.invoke(it));
            ++i$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void forEach(@NotNull SparseArray<E> $this$forEach, @NotNull Function1<? super E, Unit> action) {
        int $i$f$forEach = 0;
        Intrinsics.checkParameterIsNotNull($this$forEach, (String)"$this$forEach");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int n = 0;
        int n2 = $this$forEach.size();
        while (n < n2) {
            void i;
            Object value = $this$forEach.valueAt((int)i);
            action.invoke(value);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void forEachKeyValue(@NotNull SparseArray<E> $this$forEachKeyValue, @NotNull Function2<? super Integer, ? super E, Unit> action) {
        int $i$f$forEachKeyValue = 0;
        Intrinsics.checkParameterIsNotNull($this$forEachKeyValue, (String)"$this$forEachKeyValue");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int n = 0;
        int n2 = $this$forEachKeyValue.size();
        while (n < n2) {
            void i;
            int key = $this$forEachKeyValue.keyAt((int)i);
            Object value = $this$forEachKeyValue.valueAt((int)i);
            action.invoke((Object)key, value);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void forEachIndexed(@NotNull SparseArray<E> $this$forEachIndexed, @NotNull Function3<? super Integer, ? super E, ? super Integer, Unit> action) {
        int $i$f$forEachIndexed = 0;
        Intrinsics.checkParameterIsNotNull($this$forEachIndexed, (String)"$this$forEachIndexed");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int size = $this$forEachIndexed.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void index;
            int key = $this$forEachIndexed.keyAt((int)index);
            Object value = $this$forEachIndexed.valueAt((int)index);
            action.invoke((Object)key, value, (Object)((int)index));
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E> String toPrettyString(@NotNull SparseArray<E> $this$toPrettyString) {
        int $i$f$toPrettyString = 0;
        Intrinsics.checkParameterIsNotNull($this$toPrettyString, (String)"$this$toPrettyString");
        int size = $this$toPrettyString.size();
        List content = CollectionsKt.mutableListOf((Object[])new String[]{"size: " + size});
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            int key = $this$toPrettyString.keyAt((int)i);
            Object element = $this$toPrettyString.get(key);
            content.add(key + " = " + element);
            ++i;
        }
        return "SparseArray state: " + PrettyPrintKt.prettyStringContent$default(content, null, null, null, 7, null);
    }

    @Nullable
    public static final <E> Pair<Integer, E> keyValueAt(@NotNull SparseArray<E> $this$keyValueAt, int index) {
        int $i$f$keyValueAt = 0;
        Intrinsics.checkParameterIsNotNull($this$keyValueAt, (String)"$this$keyValueAt");
        SparseArray<E> $this$isIndexValid$iv = $this$keyValueAt;
        boolean $i$f$isIndexValid = false;
        boolean bl = index >= 0 && index < $this$isIndexValid$iv.size();
        return bl ? new Pair((Object)$this$keyValueAt.keyAt(index), $this$keyValueAt.valueAt(index)) : null;
    }

    public static final <E> boolean isIndexValid(@NotNull SparseArray<E> $this$isIndexValid, int index) {
        int $i$f$isIndexValid = 0;
        Intrinsics.checkParameterIsNotNull($this$isIndexValid, (String)"$this$isIndexValid");
        return index >= 0 && index < $this$isIndexValid.size();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <E> SparseArrayEntry<E> binarySearch(@NotNull SparseArray<E> $this$binarySearch, @NotNull Function2<? super E, ? super Integer, ? extends Comparing> compare) {
        int $i$f$binarySearch = 0;
        Intrinsics.checkParameterIsNotNull($this$binarySearch, (String)"$this$binarySearch");
        Intrinsics.checkParameterIsNotNull(compare, (String)"compare");
        int start = 0;
        int end = $this$binarySearch.size();
        while (start < end) {
            Pair pair;
            int mid = start + (end - start) / 2;
            SparseArray<E> $this$keyValueAt$iv = $this$binarySearch;
            boolean $i$f$keyValueAt = false;
            SparseArray<E> $this$isIndexValid$iv$iv = $this$keyValueAt$iv;
            boolean $i$f$isIndexValid = false;
            int n = mid >= 0 && mid < $this$isIndexValid$iv$iv.size() ? 1 : 0;
            if ((n == 1 ? new Pair((Object)$this$keyValueAt$iv.keyAt(mid), $this$keyValueAt$iv.valueAt(mid)) : null) == null) {
                void $this$toPrettyString$iv;
                $this$keyValueAt$iv = $this$binarySearch;
                StringBuilder stringBuilder = new StringBuilder().append("should never happen, mid = ").append(mid).append(", start = ").append(start).append(", end = ").append(end).append(" \n").append(" pretty SparseArray = ");
                boolean $i$f$toPrettyString = false;
                int size$iv = $this$toPrettyString$iv.size();
                List content$iv = CollectionsKt.mutableListOf((Object[])new String[]{"size: " + size$iv});
                n = 0;
                int n2 = size$iv;
                while (n < n2) {
                    void i$iv;
                    int key$iv = $this$toPrettyString$iv.keyAt((int)i$iv);
                    Object element$iv = $this$toPrettyString$iv.get(key$iv);
                    content$iv.add(key$iv + " = " + element$iv);
                    ++i$iv;
                }
                String string = "SparseArray state: " + PrettyPrintKt.prettyStringContent$default(content$iv, null, null, null, 7, null);
                String string2 = stringBuilder.append(string).toString();
                throw (Throwable)new Exception(string2);
            }
            pair = pair;
            int n3 = ((Number)pair.component1()).intValue();
            Object value = pair.component2();
            switch (SpareArrayExtensionsKt$WhenMappings.$EnumSwitchMapping$0[((Comparing)((Object)compare.invoke(value, (Object)mid))).ordinal()]) {
                case 1: {
                    start = mid + 1;
                    break;
                }
                case 2: {
                    end = mid;
                    break;
                }
                case 3: {
                    void key;
                    return new SparseArrayEntry<Object>((int)key, value);
                }
            }
        }
        return null;
    }
}

