@file:Suppress("unused", "NOTHING_TO_INLINE", "MemberVisibilityCanBePrivate")

package com.commonsense.android.kotlin.base.datastructures

import java.util.concurrent.atomic.*

/**
 * A ticket system
 * each category requests a ticket.
 * and if there has been assigned a number to a category, it will always get the same number back.
 */
class Ticketer(@androidx.annotation.IntRange(from = 0) initialValue: Int) {

    private val currentDrawNumber = AtomicInteger(initialValue)

    private val categoryStore = mutableMapOf<String, Int>()

    /**
     * Draws a number
     */
    @androidx.annotation.IntRange(from = 0)
    fun getIdForCategory(category: String): Int {
        if (!categoryStore.containsKey(category)) {
            synchronized(this) {
                if (!categoryStore.containsKey(category)) {
                    val number = drawNextNumber()
                    categoryStore[category] = number
                }
            }
        }
        return categoryStore[category] ?: 0
    }

    @androidx.annotation.IntRange(from = 0)
    private fun drawNextNumber(): Int {
        return currentDrawNumber.getAndIncrement()
    }
}
