/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.extensions.collections;

import android.support.annotation.IntRange;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.commonsense.android.kotlin.base.extensions.collections.SparseArrayEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004H\u0086\b\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0007H\u0086\b\u001a,\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t0\u0004\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\b\b\u0003\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"set", "", "Landroid/util/SparseIntArray;", "input", "", "Lkotlin/Pair;", "", "", "toList", "Lcom/commonsense/android/kotlin/base/extensions/collections/SparseArrayEntry;", "T", "Landroid/util/SparseArray;", "maxKeyValue", "base_release"})
public final class SpareArrayExtensionsKt {
    public static final void set(@NotNull SparseIntArray $receiver, @NotNull List<Pair<Integer, Integer>> input) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $receiver.clear();
        Iterable $receiver$iv = input;
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            $receiver.put(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
    }

    public static final void set(@NotNull SparseIntArray $receiver, @NotNull Map<Integer, Integer> input) {
        Map<Integer, Integer> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $receiver.clear();
        Map<Integer, Integer> map = $receiver$iv = input;
        Iterator<Map.Entry<Integer, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> element$iv;
            Map.Entry<Integer, Integer> it = element$iv = iterator.next();
            $receiver.put(((Number)it.getKey()).intValue(), ((Number)it.getValue()).intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<SparseArrayEntry<T>> toList(@NotNull SparseArray<T> $receiver, @IntRange(from=1L) int maxKeyValue) {
        void $receiver$iv$iv;
        List list;
        ArrayList list$iv;
        Iterator $receiver$iv$iv2;
        ArrayList $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$receiver.size());
        SparseArray<T> sparseArray = $receiver;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void p1;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            Integer n2 = sparseArray.keyAt((int)p1);
            collection.add(n2);
        }
        List mapped = (List)destination$iv$iv;
        if (maxKeyValue < Integer.MAX_VALUE) {
            Object item$iv;
            int it;
            $receiver$iv = (ArrayList)mapped;
            list$iv = new ArrayList();
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext() && (it = ((Number)(item$iv = $receiver$iv$iv2.next())).intValue()) <= maxKeyValue) {
                list$iv.add(item$iv);
            }
            list = list$iv;
        } else {
            list = mapped;
        }
        $receiver$iv = list;
        list$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            SparseArrayEntry<Object> sparseArrayEntry;
            SparseArrayEntry<Object> sparseArrayEntry2;
            Object element$iv$iv = element$iv$iv$iv;
            int key = ((Number)element$iv$iv).intValue();
            if ($receiver.get(key) != null) {
                Object object;
                Object it = object;
                sparseArrayEntry2 = new SparseArrayEntry<Object>(key, it);
            } else {
                sparseArrayEntry2 = null;
            }
            if (sparseArrayEntry2 == null) continue;
            SparseArrayEntry<Object> it$iv$iv = sparseArrayEntry = sparseArrayEntry2;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List toList$default(SparseArray sparseArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return SpareArrayExtensionsKt.toList(sparseArray, n);
    }
}

