/*
 * Decompiled with CFR 0.152.
 */
package com.hive.analytics.provider.firebase;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.hive.Analytics;
import com.hive.analytics.provider.AnalyticsProviderAdapter;
import com.hive.analytics.provider.firebase.AnalyticsProviderFirebase;
import com.hive.core.Configuration;
import com.hive.core.HiveCoreInitializer;
import com.hive.logger.LoggerImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040%H\u0016J\u0012\u0010&\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010(\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/hive/analytics/provider/firebase/AnalyticsProviderFirebase;", "Lcom/hive/analytics/provider/AnalyticsProviderAdapter;", "()V", "KEY_event", "", "KEY_events", "KEY_name", "KEY_value", "events", "Lorg/json/JSONArray;", "getEvents", "()Lorg/json/JSONArray;", "events$delegate", "Lkotlin/Lazy;", "firebaseAnalytics", "Lcom/google/firebase/analytics/FirebaseAnalytics;", "init", "", "did", "analyticsId", "onCreateIntent", "Landroid/content/Intent;", "onReferrerReceive", "", "context", "Landroid/content/Context;", "intent", "sendAdRevenueEvent", "analyticsAdRevenue", "Lcom/hive/Analytics$AnalyticsAdRevenue;", "sendEvent", "eventName", "sendRevenueEvent", "analyticsRevenue", "Lcom/hive/Analytics$AnalyticsRevenue;", "setConsent", "settings", "", "setCustomUserId", "userId", "setProviderEventData", "trackUnder13", "EventKeys", "hive-analytics-provider-firebase_release"})
public final class AnalyticsProviderFirebase
extends AnalyticsProviderAdapter {
    @NotNull
    public static final AnalyticsProviderFirebase INSTANCE = new AnalyticsProviderFirebase();
    @NotNull
    private static final String KEY_events = "events";
    @NotNull
    private static final String KEY_event = "event";
    @NotNull
    private static final String KEY_name = "@name";
    @NotNull
    private static final String KEY_value = "@value";
    @NotNull
    private static final Lazy events$delegate = LazyKt.lazy((Function0)events.2.INSTANCE);
    @NotNull
    private static final FirebaseAnalytics firebaseAnalytics;

    private AnalyticsProviderFirebase() {
        super(AnalyticsProviderAdapter.AnalyticsProviderType.FIREBASE);
    }

    private final JSONArray getEvents() {
        Lazy lazy = events$delegate;
        return (JSONArray)lazy.getValue();
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean init(@Nullable String did, @Nullable String analyticsId, @Nullable Intent onCreateIntent) {
        Object object;
        block2: {
            Throwable throwable;
            this.setProviderEventData();
            try {
                boolean bl = false;
                firebaseAnalytics.setAnalyticsCollectionEnabled(true);
                LoggerImpl.INSTANCE.d("[Analytics Firebase] AnalyticsProviderFirebase init success.");
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            LoggerImpl.INSTANCE.w("[Analytics Firebase] init failed: " + it);
        }
        return Result.isSuccess-impl((Object)object);
    }

    public void sendEvent(@NotNull String eventName) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!this.isEnable() || !(!this.getProviderEvent().isEmpty())) break block1;
            String string = (String)this.getProviderEvent().get(eventName);
            if (string != null) {
                String it = string;
                boolean bl = false;
                firebaseAnalytics.logEvent(((Object)StringsKt.trim((CharSequence)it)).toString(), null);
            }
        }
    }

    public void onReferrerReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
    }

    public void sendRevenueEvent(@NotNull String eventName, @NotNull Analytics.AnalyticsRevenue analyticsRevenue) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)analyticsRevenue, (String)"analyticsRevenue");
            if (!this.isEnable()) break block5;
            String string = (String)this.getProviderEvent().get(eventName);
            if (string != null) {
                Bundle bundle;
                String eventValue = string;
                boolean bl = false;
                Bundle $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243 = bundle = new Bundle();
                boolean bl2 = false;
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("price", String.valueOf(analyticsRevenue.getPriceDouble()));
                String string2 = analyticsRevenue.getCurrency();
                if (string2 == null) {
                    string2 = "";
                }
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("currency", string2);
                String string3 = analyticsRevenue.getRefId();
                if (string3 == null) {
                    string3 = "";
                }
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("order_id", string3);
                String string4 = analyticsRevenue.getPid();
                if (string4 == null) {
                    string4 = "";
                }
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("pid", string4);
                String string5 = analyticsRevenue.getTitle();
                if (string5 == null) {
                    string5 = "";
                }
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("title", string5);
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("server_id", Configuration.INSTANCE.getServerId());
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("quantity", String.valueOf(analyticsRevenue.getItemCount()));
                $this$sendRevenueEvent_u24lambda_u244_u24lambda_u243.putString("revenue", String.valueOf(analyticsRevenue.getRevenue()));
                Bundle bundle2 = bundle;
                firebaseAnalytics.logEvent(((Object)StringsKt.trim((CharSequence)eventValue)).toString(), bundle2);
            }
        }
    }

    public void sendAdRevenueEvent(@NotNull Analytics.AnalyticsAdRevenue analyticsAdRevenue) {
        Intrinsics.checkNotNullParameter((Object)analyticsAdRevenue, (String)"analyticsAdRevenue");
        if (this.isEnable()) {
            double revenue = analyticsAdRevenue.getRevenue();
            Bundle params = new Bundle();
            params.putString("ad_platform", analyticsAdRevenue.getAdPlatform());
            params.putString("ad_unit_name", analyticsAdRevenue.getAdUnitId());
            params.putString("ad_format", analyticsAdRevenue.getAdType());
            params.putDouble("value", revenue);
            params.putString("currency", analyticsAdRevenue.getCurrency());
            firebaseAnalytics.logEvent("ad_impression", params);
        }
    }

    public void trackUnder13() {
        super.trackUnder13();
        firebaseAnalytics.setAnalyticsCollectionEnabled(false);
    }

    public void setCustomUserId(@Nullable String userId) {
        firebaseAnalytics.setUserId(userId);
    }

    public void setConsent(@NotNull Map<String, String> settings) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Map map = new LinkedHashMap();
        String string = settings.get("ad_storage");
        if (Intrinsics.areEqual((Object)string, (Object)"granted")) {
            map.put(FirebaseAnalytics.ConsentType.AD_STORAGE, FirebaseAnalytics.ConsentStatus.GRANTED);
        } else if (Intrinsics.areEqual((Object)string, (Object)"denied")) {
            map.put(FirebaseAnalytics.ConsentType.AD_STORAGE, FirebaseAnalytics.ConsentStatus.DENIED);
        }
        string = settings.get("ad_user_data");
        if (Intrinsics.areEqual((Object)string, (Object)"granted")) {
            map.put(FirebaseAnalytics.ConsentType.AD_USER_DATA, FirebaseAnalytics.ConsentStatus.GRANTED);
        } else if (Intrinsics.areEqual((Object)string, (Object)"denied")) {
            map.put(FirebaseAnalytics.ConsentType.AD_USER_DATA, FirebaseAnalytics.ConsentStatus.DENIED);
        }
        string = settings.get("ad_personalization");
        if (Intrinsics.areEqual((Object)string, (Object)"granted")) {
            map.put(FirebaseAnalytics.ConsentType.AD_PERSONALIZATION, FirebaseAnalytics.ConsentStatus.GRANTED);
        } else if (Intrinsics.areEqual((Object)string, (Object)"denied")) {
            map.put(FirebaseAnalytics.ConsentType.AD_PERSONALIZATION, FirebaseAnalytics.ConsentStatus.DENIED);
        }
        string = settings.get("analytics_storage");
        if (Intrinsics.areEqual((Object)string, (Object)"granted")) {
            map.put(FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE, FirebaseAnalytics.ConsentStatus.GRANTED);
        } else if (Intrinsics.areEqual((Object)string, (Object)"denied")) {
            map.put(FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE, FirebaseAnalytics.ConsentStatus.DENIED);
        }
        LoggerImpl.INSTANCE.d("[AnalyticsProviderFirebase] setConsent : " + map);
        firebaseAnalytics.setConsent(map);
    }

    private final void setProviderEventData() {
        int n = this.getEvents().length();
        for (int i = 0; i < n; ++i) {
            if (this.getEvents().optJSONObject(i) == null) continue;
            boolean bl = false;
            try {
                JSONObject it;
                String name = it.getString(KEY_name);
                String value = it.getString(KEY_value);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (!(!StringsKt.isBlank((CharSequence)name))) continue;
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (!(!StringsKt.isBlank((CharSequence)value))) continue;
                INSTANCE.getProviderEvent().put(name, value);
            }
            catch (Exception exception) {
            }
        }
    }

    public static final /* synthetic */ JSONObject access$getProviderJsonObject(AnalyticsProviderFirebase $this) {
        return $this.getProviderJsonObject();
    }

    static {
        FirebaseAnalytics firebaseAnalytics = FirebaseAnalytics.getInstance((Context)HiveCoreInitializer.Companion.getInitContext());
        Intrinsics.checkNotNullExpressionValue((Object)firebaseAnalytics, (String)"getInstance(HiveCoreInitializer.initContext)");
        AnalyticsProviderFirebase.firebaseAnalytics = firebaseAnalytics;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/hive/analytics/provider/firebase/AnalyticsProviderFirebase$EventKeys;", "", "()V", "currency", "", "orderId", "pid", "price", "quantity", "revenue", "serverId", "title", "hive-analytics-provider-firebase_release"})
    public static final class EventKeys {
        @NotNull
        public static final EventKeys INSTANCE = new EventKeys();
        @NotNull
        public static final String price = "price";
        @NotNull
        public static final String currency = "currency";
        @NotNull
        public static final String orderId = "order_id";
        @NotNull
        public static final String pid = "pid";
        @NotNull
        public static final String title = "title";
        @NotNull
        public static final String serverId = "server_id";
        @NotNull
        public static final String quantity = "quantity";
        @NotNull
        public static final String revenue = "revenue";

        private EventKeys() {
        }
    }
}

