/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Preconditions;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatingDistributedLock
implements DistributedLock {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LockId lockId;
    private final OwnerId ownerId;
    private final LockDuration duration;
    private final AcquireAction acquireAction;
    private final ReleaseAction releaseAction;

    DelegatingDistributedLock(AcquireAction acquireAction, ReleaseAction releaseAction, LockId lockId, OwnerId ownerId, LockDuration duration) {
        this.lockId = (LockId)Preconditions.expectNonNull((Object)lockId);
        this.ownerId = (OwnerId)Preconditions.expectNonNull((Object)ownerId);
        this.duration = (LockDuration)Preconditions.expectNonNull((Object)duration);
        this.acquireAction = acquireAction;
        this.releaseAction = releaseAction;
    }

    @Override
    public String getId() {
        return this.lockId.getValue();
    }

    @Override
    public boolean acquire() {
        return this.acquire(new LockRequest(this.lockId, this.ownerId, this.duration));
    }

    @Override
    public boolean acquire(Duration duration) {
        LockDuration lockDuration = LockDuration.of((Duration)duration);
        return this.acquire(new LockRequest(this.lockId, this.ownerId, lockDuration));
    }

    @Override
    public boolean acquireForever() {
        return this.acquire(new LockRequest(this.lockId, this.ownerId, null));
    }

    @Override
    public boolean release() {
        boolean released = this.releaseAction.release(this.lockId, this.ownerId);
        if (released) {
            this.logger.debug("Lock released: {}", (Object)this.lockId);
        } else {
            this.logger.debug("Lock not released: {}", (Object)this.lockId);
        }
        return released;
    }

    private boolean acquire(LockRequest lockRequest) {
        boolean acquired = this.acquireAction.acquire(lockRequest);
        if (acquired) {
            this.logger.debug("Lock acquired: {}, {}", (Object)this.lockId, (Object)lockRequest);
        } else {
            this.logger.debug("Lock not acquired: {}, {}", (Object)this.lockId, (Object)lockRequest);
        }
        return acquired;
    }

    @FunctionalInterface
    public static interface AcquireAction {
        public boolean acquire(LockRequest var1);
    }

    @FunctionalInterface
    public static interface ReleaseAction {
        public boolean release(LockId var1, OwnerId var2);
    }
}

