/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarSkipCondition;
import com.coditory.gradle.webjar.shared.TimeMarkers;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0006H\u0007J\b\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/coditory/gradle/webjar/WebjarTestTask;", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "(Lcom/coditory/gradle/webjar/WebjarExtension;)V", "cacheInputs", "", "paths", "", "", "project", "Lorg/gradle/api/Project;", "run", "setupCache", "Companion", "webjar-plugin"})
public abstract class WebjarTestTask
extends NpmTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebjarExtension webjar;

    @Inject
    public WebjarTestTask(@NotNull WebjarExtension webjar) {
        Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
        this.webjar = webjar;
        this.setGroup("webjar");
        Object[] objectArray = new String[]{"run", this.webjar.getTaskNames().getTest()};
        this.getArgs().set((Iterable)CollectionsKt.listOf((Object[])objectArray));
        if (this.webjar.getCache().getEnabled() && this.webjar.getCache().getCacheTest()) {
            this.setupCache();
        }
    }

    private final void setupCache() {
        List<String> list = this.webjar.getCache().getSrc();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.cacheInputs(list, project);
        List<String> list2 = this.webjar.getCache().getTest();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.cacheInputs(list2, project2);
        Object[] objectArray = new Object[]{".babelrc", "jest.config.js", "cypress.json", "package.json", "package-lock.json"};
        this.getInputs().files(objectArray);
        TaskOutputsInternal taskOutputsInternal = this.getOutputs();
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        taskOutputsInternal.file((Object)FilesKt.resolve((File)file, (String)this.webjar.getCache().getTestTimestampFile()));
    }

    @TaskAction
    public final void run() {
        this.exec();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        TimeMarkers.createTimeMarkerFile$default(TimeMarkers.INSTANCE, project, this.webjar.getCache().getTestTimestampFile(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void cacheInputs(List<String> paths, Project project) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = project.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            collection.add(FilesKt.resolve((File)file, (String)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                this.getInputs().dir((Object)it);
                continue;
            }
            if (!it.isFile()) continue;
            this.getInputs().file((Object)it);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/coditory/gradle/webjar/WebjarTestTask$Companion;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Project project, @NotNull WebjarExtension webjar) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
            Object[] objectArray = new Object[]{webjar};
            TaskProvider taskProvider = project.getTasks().register("webjarTest", WebjarTestTask.class, objectArray);
            taskProvider.configure(Companion::install$lambda-0);
            if (!WebjarSkipCondition.INSTANCE.isWebjarSkipped(project)) {
                project.getTasks().named("test").configure(arg_0 -> Companion.install$lambda-1(taskProvider, arg_0));
            }
        }

        private static final void install$lambda-0(WebjarTestTask it) {
            Object[] objectArray = new Object[]{"webjarInstall"};
            it.dependsOn(objectArray);
        }

        private static final void install$lambda-1(TaskProvider $taskProvider, Task it) {
            Object[] objectArray = new Object[]{$taskProvider};
            it.dependsOn(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

