/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.shared.VersionFiles;
import com.github.gradle.node.NodeExtension;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lcom/coditory/gradle/webjar/WebjarRemoveModulesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "normalizeVersion", "", "value", "removeNpmModules", "", "project", "Lorg/gradle/api/Project;", "removeStaleNpmModules", "Companion", "webjar-plugin"})
public abstract class WebjarRemoveModulesTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WebjarRemoveModulesTask() {
        this.setGroup("webjar");
    }

    @TaskAction
    public final void removeStaleNpmModules() {
        boolean versionChanged;
        NodeExtension node = (NodeExtension)this.getProject().getExtensions().findByType(NodeExtension.class);
        NodeExtension nodeExtension = node;
        String nodeVersion = this.normalizeVersion(nodeExtension != null && (nodeExtension = nodeExtension.getVersion()) != null ? (String)nodeExtension.getOrNull() : null);
        NodeExtension nodeExtension2 = node;
        String npmVersion = this.normalizeVersion(nodeExtension2 != null && (nodeExtension2 = nodeExtension2.getNpmVersion()) != null ? (String)nodeExtension2.getOrNull() : null);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String lastNodeVersion = VersionFiles.INSTANCE.nodeVersionFile(project).read();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String lastNpmVersion = VersionFiles.INSTANCE.npmVersionFile(project2).read();
        boolean bl = versionChanged = !Intrinsics.areEqual((Object)lastNodeVersion, (Object)nodeVersion) || !Intrinsics.areEqual((Object)lastNpmVersion, (Object)npmVersion);
        if (versionChanged) {
            this.getLogger().warn("Node/NPM version changed - removing node_modules in order to rebuild dependencies");
            this.getLogger().warn("  Node detected: " + lastNodeVersion + ", expected: " + nodeVersion);
            this.getLogger().warn("  NPM  detected: " + lastNpmVersion + ", expected: " + npmVersion);
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            this.removeNpmModules(project3);
        }
    }

    private final String normalizeVersion(String value) {
        CharSequence charSequence = value;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "undefined" : value;
    }

    private final void removeNpmModules(Project project) {
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File nodeModulesDir = FilesKt.resolve((File)file, (String)"node_modules");
        FilesKt.deleteRecursively((File)nodeModulesDir);
        nodeModulesDir.mkdirs();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/coditory/gradle/webjar/WebjarRemoveModulesTask$Companion;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.getTasks().register("webjarRemoveModules", WebjarRemoveModulesTask.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

