/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarSkipCondition;
import com.coditory.gradle.webjar.shared.TimeMarkers;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/coditory/gradle/webjar/WebjarLintTask;", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "(Lcom/coditory/gradle/webjar/WebjarExtension;)V", "cacheEnabled", "", "run", "", "setupCache", "Companion", "webjar-plugin"})
public abstract class WebjarLintTask
extends NpmTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebjarExtension webjar;
    private final boolean cacheEnabled;

    @Inject
    public WebjarLintTask(@NotNull WebjarExtension webjar) {
        Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
        this.webjar = webjar;
        this.cacheEnabled = this.webjar.getCache().getEnabled() && this.webjar.getCache().getCacheLint();
        this.setGroup("webjar");
        Object[] objectArray = new String[]{"run", this.webjar.getTaskNames().getLint()};
        this.getArgs().set((Iterable)CollectionsKt.listOf((Object[])objectArray));
        if (this.cacheEnabled) {
            this.setupCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupCache() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.webjar.getCache().getSrc();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.getProject().getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            collection.add(FilesKt.resolve((File)file, (String)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                this.getInputs().dir((Object)it);
                continue;
            }
            if (!it.isFile()) continue;
            this.getInputs().file((Object)it);
        }
        Object[] objectArray = new Object[]{".eslintrc", ".eslintignore", "package.json"};
        this.getInputs().files(objectArray);
        TaskOutputsInternal taskOutputsInternal = this.getOutputs();
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        taskOutputsInternal.file((Object)FilesKt.resolve((File)file, (String)this.webjar.getCache().getLintTimestampFile()));
    }

    @TaskAction
    public final void run() {
        this.exec();
        if (this.cacheEnabled) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            TimeMarkers.createTimeMarkerFile$default(TimeMarkers.INSTANCE, project, this.webjar.getCache().getLintTimestampFile(), null, 4, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/coditory/gradle/webjar/WebjarLintTask$Companion;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Project project, @NotNull WebjarExtension webjar) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
            Object[] objectArray = new Object[]{webjar};
            TaskProvider lintTaskProvider = project.getTasks().register("webjarLint", WebjarLintTask.class, objectArray);
            lintTaskProvider.configure(Companion::install$lambda-0);
            if (!WebjarSkipCondition.INSTANCE.isWebjarSkipped(project)) {
                project.getTasks().named("check").configure(arg_0 -> Companion.install$lambda-1(lintTaskProvider, arg_0));
            }
        }

        private static final void install$lambda-0(WebjarLintTask it) {
            Object[] objectArray = new Object[]{"webjarInstall"};
            it.dependsOn(objectArray);
        }

        private static final void install$lambda-1(TaskProvider $lintTaskProvider, Task it) {
            Object[] objectArray = new Object[]{$lintTaskProvider};
            it.dependsOn(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

