/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.shared.SemVersion;
import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/coditory/gradle/webjar/WebjarInitTask;", "Lcom/github/gradle/node/npm/task/NpmTask;", "()V", "ensurePackageJson", "", "project", "Lorg/gradle/api/Project;", "resolveNpmArguments", "", "", "Companion", "webjar-plugin"})
public abstract class WebjarInitTask
extends NpmTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WebjarInitTask() {
        this.setGroup("webjar");
        Object[] objectArray = new Object[]{"package.json"};
        this.getInputs().files(objectArray);
        this.getOutputs().file((Object)"package-lock.json");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.ensurePackageJson(project);
        ListProperty listProperty = this.getArgs();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        listProperty.set((Iterable)this.resolveNpmArguments(project2));
    }

    private final List<String> resolveNpmArguments(Project project) {
        List list;
        NodeExtension node = (NodeExtension)project.getExtensions().findByType(NodeExtension.class);
        NodeExtension nodeExtension = node;
        SemVersion npmSemVersion = SemVersion.Companion.parseOrNull(nodeExtension != null && (nodeExtension = nodeExtension.getNpmVersion()) != null ? (String)nodeExtension.getOrNull() : null);
        if (npmSemVersion == null || npmSemVersion.compareTo(SemVersion.Companion.parse("6.0.0")) >= 0) {
            Object[] objectArray = new String[]{"install", "--package-lock-only"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"install");
        }
        return list;
    }

    private final void ensurePackageJson(Project project) {
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File packageJsonFile = FilesKt.resolve((File)file, (String)"package.json");
        if (!packageJsonFile.isFile()) {
            packageJsonFile.createNewFile();
            FilesKt.writeText$default((File)packageJsonFile, (String)StringsKt.trimIndent((String)("\n                {\n                    \"name\": \"" + project.getName() + "\",\n                    \"scripts\": {\n                        \"lint\": \"echo 'missing lint script'\",\n                        \"test\": \"echo 'missing test script'\",\n                        \"clean\": \"echo 'missing clean script'\",\n                        \"build\": \"echo 'missing build script'\",\n                        \"watch\": \"echo 'missing watch script'\"\n                    }\n                }\n                ")), null, (int)2, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/coditory/gradle/webjar/WebjarInitTask$Companion;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.getTasks().register("webjarInit", WebjarInitTask.class).configure(Companion::install$lambda-0);
        }

        private static final void install$lambda-0(WebjarInitTask it) {
            Object[] objectArray = new Object[]{"npmSetup"};
            it.dependsOn(objectArray);
            objectArray = new Object[]{"webjarRemoveModules"};
            it.dependsOn(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

