/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarSkipCondition;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b \u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/coditory/gradle/webjar/WebjarBuildTask;", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "(Lcom/coditory/gradle/webjar/WebjarExtension;)V", "copyToJarOutput", "", "run", "setupCache", "Companion", "webjar-plugin"})
public abstract class WebjarBuildTask
extends NpmTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebjarExtension webjar;

    @Inject
    public WebjarBuildTask(@NotNull WebjarExtension webjar) {
        Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
        this.webjar = webjar;
        this.setGroup("webjar");
        Object[] objectArray = new String[]{"run", this.webjar.getTaskNames().getBuild()};
        this.getArgs().set((Iterable)CollectionsKt.listOf((Object[])objectArray));
        if (this.webjar.getCache().getEnabled()) {
            this.setupCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupCache() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.webjar.getCache().getSrc();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.getProject().getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            collection.add(FilesKt.resolve((File)file, (String)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                this.getInputs().dir((Object)it);
                continue;
            }
            if (!it.isFile()) continue;
            this.getInputs().file((Object)it);
        }
        Object[] objectArray = new Object[]{"package.json", "package-lock.json", ".babelrc", ".tsconfig.json"};
        this.getInputs().files(objectArray);
        this.getOutputs().dir((Object)this.webjar.getDistDir());
    }

    @TaskAction
    public final void run() {
        this.exec();
        this.copyToJarOutput();
    }

    private final void copyToJarOutput() {
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File from = FilesKt.resolve((File)file, (String)this.webjar.getDistDir());
        if (from.isDirectory()) {
            File file2 = this.getProject().getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
            File to = FilesKt.resolve((File)FilesKt.resolve((File)file2, (String)this.webjar.getOutputDir()), (String)this.webjar.getWebjarDir());
            to.mkdirs();
            FilesKt.copyRecursively$default((File)from, (File)to, (boolean)true, null, (int)4, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/coditory/gradle/webjar/WebjarBuildTask$Companion;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Project project, @NotNull WebjarExtension webjar) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
            Object[] objectArray = new Object[]{webjar};
            TaskProvider taskProvider = project.getTasks().register("webjarBuild", WebjarBuildTask.class, objectArray);
            taskProvider.configure(Companion::install$lambda-0);
            if (!WebjarSkipCondition.INSTANCE.isWebjarSkipped(project)) {
                project.getTasks().named("processResources").configure(arg_0 -> Companion.install$lambda-1(taskProvider, arg_0));
            }
        }

        private static final void install$lambda-0(WebjarBuildTask it) {
            Object[] objectArray = new Object[]{"webjarInstall"};
            it.dependsOn(objectArray);
        }

        private static final void install$lambda-1(TaskProvider $taskProvider, Task it) {
            Object[] objectArray = new Object[]{$taskProvider};
            it.dependsOn(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

