/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarBuildTask;
import com.coditory.gradle.webjar.WebjarCleanTask;
import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarInitTask;
import com.coditory.gradle.webjar.WebjarInstallTask;
import com.coditory.gradle.webjar.WebjarLintTask;
import com.coditory.gradle.webjar.WebjarRemoveModulesTask;
import com.coditory.gradle.webjar.WebjarTestTask;
import com.coditory.gradle.webjar.WebjarWatchTask;
import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.NodePlugin;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/coditory/gradle/webjar/WebjarPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "setupNodePlugin", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "setupWebjarExtension", "setupWebjarTasks", "Companion", "webjar-plugin"})
public class WebjarPlugin
implements Plugin<Project> {
    @NotNull
    public static final String PLUGIN_ID = "com.coditory.webjar";
    @NotNull
    public static final String WEBJAR_TASK_GROUP = "webjar";
    @NotNull
    public static final String WEBJAR_EXTENSION = "webjar";
    @NotNull
    public static final String WEBJAR_REMOVE_MODULES_TASK = "webjarRemoveModules";
    @NotNull
    public static final String WEBJAR_INIT_TASK = "webjarInit";
    @NotNull
    public static final String WEBJAR_INSTALL_TASK = "webjarInstall";
    @NotNull
    public static final String WEBJAR_CLEAN_TASK = "webjarClean";
    @NotNull
    public static final String WEBJAR_LINT_TASK = "webjarLint";
    @NotNull
    public static final String WEBJAR_TEST_TASK = "webjarTest";
    @NotNull
    public static final String WEBJAR_WATCH_TASK = "webjarWatch";
    @NotNull
    public static final String WEBJAR_BUILD_TASK = "webjarBuild";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            project.getPlugins().apply(JavaPlugin.class);
        }
        WebjarExtension webjar = this.setupWebjarExtension(project);
        this.setupNodePlugin(project, webjar);
        this.setupWebjarTasks(project, webjar);
    }

    private final void setupNodePlugin(Project project, WebjarExtension webjar) {
        Object object = project.getExtensions().getByType(JavaPluginExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project\n            .ext\u2026ginExtension::class.java)");
        Object object2 = ((JavaPluginExtension)object).getSourceSets().getByName("main");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project\n            .ext\u2026Set.MAIN_SOURCE_SET_NAME)");
        SourceDirectorySet sourceDirectorySet = ((SourceSet)object2).getResources();
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        sourceDirectorySet.srcDir((Object)FilesKt.resolve((File)file, (String)webjar.getOutputDir()));
        project.getPlugins().apply(NodePlugin.class);
        project.getExtensions().configure(NodeExtension.class, (Action)new Action<NodeExtension>(project){
            final /* synthetic */ Project $project;

            public final void execute(NodeExtension it) {
                DirectoryProperty directoryProperty = it.getWorkDir();
                File file = this.$project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                directoryProperty.set(FilesKt.resolve((File)file, (String)".node/node"));
                DirectoryProperty directoryProperty2 = it.getNpmWorkDir();
                File file2 = this.$project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.projectDir");
                directoryProperty2.set(FilesKt.resolve((File)file2, (String)".node/npm"));
                DirectoryProperty directoryProperty3 = it.getYarnWorkDir();
                File file3 = this.$project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.projectDir");
                directoryProperty3.set(FilesKt.resolve((File)file3, (String)".node/yarn"));
                it.getDownload().set((Object)true);
                it.getVersion().set((Object)"16.5.0");
                it.getNpmVersion().set((Object)"7.19.1");
            }
            {
                this.$project = project;
            }
        });
    }

    private final WebjarExtension setupWebjarExtension(Project project) {
        Object object = project.getExtensions().create("webjar", WebjarExtension.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026jarExtension::class.java)");
        return (WebjarExtension)object;
    }

    private final void setupWebjarTasks(Project project, WebjarExtension webjar) {
        WebjarInitTask.INSTANCE.install(project);
        WebjarBuildTask.INSTANCE.install(project, webjar);
        WebjarCleanTask.INSTANCE.install(project, webjar);
        WebjarInstallTask.INSTANCE.install(project);
        WebjarLintTask.INSTANCE.install(project, webjar);
        WebjarRemoveModulesTask.INSTANCE.install(project);
        WebjarTestTask.INSTANCE.install(project, webjar);
        WebjarWatchTask.INSTANCE.install(project, webjar);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/coditory/gradle/webjar/WebjarPlugin$Companion;", "", "()V", "PLUGIN_ID", "", "WEBJAR_BUILD_TASK", "WEBJAR_CLEAN_TASK", "WEBJAR_EXTENSION", "WEBJAR_INIT_TASK", "WEBJAR_INSTALL_TASK", "WEBJAR_LINT_TASK", "WEBJAR_REMOVE_MODULES_TASK", "WEBJAR_TASK_GROUP", "WEBJAR_TEST_TASK", "WEBJAR_WATCH_TASK", "webjar-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

