/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarBuildTask;
import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarSkipCondition;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/coditory/gradle/webjar/WebjarBuildTask;", "", "()V", "copyToJarOutput", "", "project", "Lorg/gradle/api/Project;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "install", "setupCaching", "task", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar-plugin"})
public final class WebjarBuildTask {
    @NotNull
    public static final WebjarBuildTask INSTANCE;

    public final void install(@NotNull Project project, @NotNull WebjarExtension webjar) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
        TaskProvider buildTask2 = project.getTasks().register("webjarBuild", NpmTask.class, (Action)new Action<NpmTask>(webjar, project){
            final /* synthetic */ WebjarExtension $webjar;
            final /* synthetic */ Project $project;

            public final void execute(NpmTask task) {
                NpmTask npmTask = task;
                Intrinsics.checkNotNullExpressionValue((Object)npmTask, (String)"task");
                npmTask.setGroup("webjar");
                task.dependsOn(new Object[]{"webjarInstall"});
                task.getArgs().set((Iterable)CollectionsKt.listOf((Object[])new String[]{"run", this.$webjar.getTaskNames().getBuild()}));
                task.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ install.buildTask.1 this$0;

                    public final void execute(Task it) {
                        WebjarBuildTask.access$copyToJarOutput(WebjarBuildTask.INSTANCE, this.this$0.$project, this.this$0.$webjar);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (this.$webjar.getCache().getEnabled()) {
                    WebjarBuildTask.access$setupCaching(WebjarBuildTask.INSTANCE, this.$project, this.$webjar, task);
                }
            }
            {
                this.$webjar = webjarExtension;
                this.$project = project;
            }
        });
        if (!WebjarSkipCondition.INSTANCE.isWebjarSkipped(project)) {
            project.getTasks().named("processResources").configure((Action)new Action<Task>(buildTask2){
                final /* synthetic */ TaskProvider $buildTask;

                public final void execute(Task it) {
                    it.dependsOn(new Object[]{this.$buildTask});
                }
                {
                    this.$buildTask = taskProvider;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupCaching(Project project, WebjarExtension webjar, NpmTask task) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = webjar.getCache().getSrc();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = project.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            File file2 = FilesKt.resolve((File)file, (String)it);
            collection.add(file2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                task.getInputs().dir((Object)it);
                continue;
            }
            if (!it.isFile()) continue;
            task.getInputs().file((Object)it);
        }
        task.getInputs().files(new Object[]{"package.json", "package-lock.json", ".babelrc", ".tsconfig.json"});
        task.getOutputs().dir((Object)webjar.getDistDir());
    }

    private final void copyToJarOutput(Project project, WebjarExtension webjar) {
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File from = FilesKt.resolve((File)file, (String)webjar.getDistDir());
        if (from.isDirectory()) {
            File file2 = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
            File to = FilesKt.resolve((File)FilesKt.resolve((File)file2, (String)webjar.getOutputDir()), (String)webjar.getWebjarDir());
            to.mkdirs();
            FilesKt.copyRecursively$default((File)from, (File)to, (boolean)true, null, (int)4, null);
        }
    }

    private WebjarBuildTask() {
    }

    static {
        WebjarBuildTask webjarBuildTask;
        INSTANCE = webjarBuildTask = new WebjarBuildTask();
    }

    public static final /* synthetic */ void access$copyToJarOutput(WebjarBuildTask $this, Project project, WebjarExtension webjar) {
        $this.copyToJarOutput(project, webjar);
    }

    public static final /* synthetic */ void access$setupCaching(WebjarBuildTask $this, Project project, WebjarExtension webjar, NpmTask task) {
        $this.setupCaching(project, webjar, task);
    }
}

