/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.BaseCryptoContext;
import com.codingrodent.jackson.crypto.EncryptionException;

public class PasswordCryptoContext
extends BaseCryptoContext {
    public static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    public static final String KEY_NAME = "PBKDF2WithHmacSHA512";
    public static final int MIN_PASSWORD_LENGTH = 8;

    public PasswordCryptoContext(String readPassword, String writePassword, String cipherName, String keyName, int iterationCount, int keyLength, String algorithmType) throws EncryptionException {
        super(readPassword, writePassword, cipherName, keyName, iterationCount, keyLength, algorithmType);
        if (readPassword.length() < 8 || writePassword.length() < 8) {
            throw new EncryptionException("Minimum password length is 8 characters");
        }
    }

    public PasswordCryptoContext(String readPassword, String writePassword, String cipherName, String keyGeneratorName) throws EncryptionException {
        super(readPassword, writePassword, cipherName, keyGeneratorName);
        if (readPassword.length() < 8 || writePassword.length() < 8) {
            throw new EncryptionException("Minimum password length is 8 characters");
        }
    }

    public PasswordCryptoContext(String readPassword, String writePassword) throws EncryptionException {
        this(readPassword, writePassword, CIPHER_NAME, KEY_NAME);
    }

    public PasswordCryptoContext(String password) throws EncryptionException {
        this(password, password);
    }
}

