/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.Encrypt;
import com.codingrodent.jackson.crypto.EncryptedJsonSerializer;
import com.codingrodent.jackson.crypto.EncryptionException;
import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedSerializerModifier
extends BeanSerializerModifier {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedSerializerModifier.class);
    private final EncryptionService encryptionService;

    public EncryptedSerializerModifier(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDescription, List<BeanPropertyWriter> beanProperties) {
        ArrayList<BeanPropertyWriter> newWriters = new ArrayList<BeanPropertyWriter>();
        for (BeanPropertyWriter writer : beanProperties) {
            if (null == writer.getAnnotation(Encrypt.class)) {
                newWriters.add(writer);
                continue;
            }
            try {
                EncryptedJsonSerializer encryptSer = new EncryptedJsonSerializer(this.encryptionService, (JsonSerializer<Object>)writer.getSerializer());
                newWriters.add(new EncryptedPropertyWriter(writer, encryptSer));
            }
            catch (Exception e) {
                logger.error("Only string encryption supported at present");
                throw new EncryptionException("Type to encrypt is unsupported");
            }
        }
        return newWriters;
    }

    static class EncryptedPropertyWriter
    extends BeanPropertyWriter {
        EncryptedPropertyWriter(BeanPropertyWriter base, JsonSerializer<Object> serializer) {
            super(base);
            this._serializer = serializer;
        }
    }
}

