/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.bean;

import com.codingapi.txlcn.txmsg.RpcConfig;
import com.codingapi.txlcn.txmsg.dto.AppInfo;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.dto.RpcResponseState;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.netty.bean.NettyRpcCmd;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketManager {
    private static final Logger log = LoggerFactory.getLogger(SocketManager.class);
    private Map<String, AppInfo> appNames;
    private ScheduledExecutorService executorService;
    private ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private static SocketManager manager = null;
    private long attrDelayTime = 60000L;

    private SocketManager() {
        this.appNames = new ConcurrentHashMap<String, AppInfo>();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (manager != null) return manager;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (manager != null) return manager;
            manager = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public void addChannel(Channel channel) {
        this.channels.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove((Object)channel);
        String key = channel.remoteAddress().toString();
        if (this.attrDelayTime < 0L) {
            this.appNames.remove(key);
            return;
        }
        try {
            this.executorService.schedule(() -> this.appNames.remove(key), this.attrDelayTime, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private Channel getChannel(String key) throws RpcException {
        for (Channel channel : this.channels) {
            String val = channel.remoteAddress().toString();
            if (!key.equals(val)) continue;
            return channel;
        }
        throw new RpcException("channel not online.");
    }

    public RpcResponseState send(String key, RpcCmd cmd) throws RpcException {
        Channel channel = this.getChannel(key);
        ChannelFuture future = channel.writeAndFlush((Object)cmd).syncUninterruptibly();
        return future.isSuccess() ? RpcResponseState.success : RpcResponseState.fail;
    }

    public MessageDto request(String key, RpcCmd cmd, long timeout) throws RpcException {
        NettyRpcCmd nettyRpcCmd = (NettyRpcCmd)cmd;
        log.debug("get channel, key:{}", (Object)key);
        Channel channel = this.getChannel(key);
        channel.writeAndFlush((Object)nettyRpcCmd);
        log.debug("await response");
        if (timeout < 1L) {
            nettyRpcCmd.await();
        } else {
            nettyRpcCmd.await(timeout);
        }
        MessageDto res = cmd.loadResult();
        log.debug("response is: {}", (Object)res);
        nettyRpcCmd.loadRpcContent().clear();
        return res;
    }

    public MessageDto request(String key, RpcCmd cmd) throws RpcException {
        return this.request(key, cmd, -1L);
    }

    public List<String> loadAllRemoteKey() {
        ArrayList<String> allKeys = new ArrayList<String>();
        for (Channel channel : this.channels) {
            allKeys.add(channel.remoteAddress().toString());
        }
        return allKeys;
    }

    public ChannelGroup getChannels() {
        return this.channels;
    }

    public int currentSize() {
        return this.channels.size();
    }

    public boolean noConnect(SocketAddress socketAddress) {
        for (Channel channel : this.channels) {
            if (!channel.remoteAddress().toString().equals(socketAddress.toString())) continue;
            return false;
        }
        return true;
    }

    public List<String> removeKeys(String moduleName) {
        ArrayList<String> allKeys = new ArrayList<String>();
        for (Channel channel : this.channels) {
            if (!moduleName.equals(this.getModuleName(channel))) continue;
            allKeys.add(channel.remoteAddress().toString());
        }
        return allKeys;
    }

    public void bindModuleName(String remoteKey, String appName, String labelName) throws RpcException {
        AppInfo appInfo = new AppInfo();
        appInfo.setAppName(appName);
        appInfo.setLabelName(labelName);
        appInfo.setCreateTime(new Date());
        if (this.containsLabelName(labelName)) {
            throw new RpcException("labelName:" + labelName + " has exist.");
        }
        this.appNames.put(remoteKey, appInfo);
    }

    public boolean containsLabelName(String moduleName) {
        Set<String> keys = this.appNames.keySet();
        for (String key : keys) {
            AppInfo appInfo = this.appNames.get(key);
            if (!moduleName.equals(appInfo.getAppName())) continue;
            return true;
        }
        return false;
    }

    public void setRpcConfig(RpcConfig rpcConfig) {
        this.attrDelayTime = rpcConfig.getAttrDelayTime();
    }

    public String getModuleName(Channel channel) {
        String key = channel.remoteAddress().toString();
        return this.getModuleName(key);
    }

    public String getModuleName(String remoteKey) {
        AppInfo appInfo = this.appNames.get(remoteKey);
        return appInfo == null ? null : appInfo.getAppName();
    }

    public List<AppInfo> appInfos() {
        return new ArrayList<AppInfo>(this.appNames.values());
    }
}

