/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger;

import com.codingapi.txlcn.common.util.SpringUtils;
import com.codingapi.txlcn.logger.AbstractTxLogger;
import com.codingapi.txlcn.logger.db.TxLog;
import com.codingapi.txlcn.logger.helper.TxLcnLogDbHelper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTxLogger
extends AbstractTxLogger {
    private static final Logger log = LoggerFactory.getLogger(DefaultTxLogger.class);
    private TxLcnLogDbHelper txLcnLogDbHelper;
    private boolean needAware = true;

    public DefaultTxLogger(Class<?> className) {
        super(className);
    }

    public void setTxLcnLogDbHelper(TxLcnLogDbHelper txLcnLogDbHelper) {
        this.txLcnLogDbHelper = txLcnLogDbHelper;
    }

    @Override
    public void saveLog(TxLog txLog) {
        if (this.needAware && Objects.isNull(this.txLcnLogDbHelper)) {
            this.txLcnLogDbHelper = (TxLcnLogDbHelper)SpringUtils.getBean(TxLcnLogDbHelper.class);
            this.needAware = false;
        }
        if (Objects.nonNull(this.txLcnLogDbHelper)) {
            this.txLcnLogDbHelper.insert(txLog);
            return;
        }
        log.warn("tx-logger db configure fail.");
    }
}

