/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.support;

import com.codetaco.date.CalendarFactory;
import com.codetaco.math.impl.support.EquationSupport;
import com.codetaco.math.impl.token.TokVariableWithValue;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEquationSupport
implements EquationSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultEquationSupport.class.getName());
    private Hashtable<String, Variable> variables;

    public DefaultEquationSupport() {
        this.setVariables(new Hashtable<String, Variable>());
        this.initializeWellKnownVariables();
    }

    @Override
    public void assignVariable(String variableName, Object value) throws Exception {
        this.assignVariable(variableName, value, false);
    }

    @Override
    public void assignVariable(String variableName, Object value, boolean sysgen) throws Exception {
        if (value instanceof Date) {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, CalendarFactory.asZoned((Date)((Date)value), (String[])new String[0]), sysgen));
        } else if (value instanceof Calendar) {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, CalendarFactory.asZoned((Calendar)((Calendar)value), (String[])new String[0]), sysgen));
        } else if (value instanceof LocalDateTime) {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, CalendarFactory.asZoned((LocalDateTime)((LocalDateTime)value), (String[])new String[0]), sysgen));
        } else if (value instanceof LocalDate) {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, CalendarFactory.asZoned((LocalDate)((LocalDate)value), (String[])new String[0]), sysgen));
        } else if (value instanceof LocalTime) {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, CalendarFactory.asZoned((LocalTime)((LocalTime)value), (String[])new String[0]), sysgen));
        } else {
            this.getVariables().put(variableName.toLowerCase(), new Variable(variableName, value, sysgen));
        }
    }

    @Override
    public void clear() {
        Enumeration<Variable> varIter = this.getVariables().elements();
        while (varIter.hasMoreElements()) {
            Variable var = varIter.nextElement();
            if (var.systemGenerated) continue;
            this.removeVariable(var.name);
        }
    }

    @Override
    public Set<String> getVariableNames() {
        return this.getVariableNames(true);
    }

    @Override
    public Set<String> getVariableNames(boolean includeSystemGenerated) {
        if (includeSystemGenerated) {
            return this.variables.keySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (String name : this.variables.keySet()) {
            if (this.getVariables().get((Object)name).systemGenerated) continue;
            names.add(name);
        }
        return names;
    }

    private Hashtable<String, Variable> getVariables() {
        return this.variables;
    }

    private void initializeWellKnownVariables() {
        try {
            this.assignVariable("PI", Math.PI, true);
            this.assignVariable("E", Math.E, true);
            this.assignVariable("true", new Boolean(true), true);
            this.assignVariable("false", new Boolean(false), true);
            this.assignVariable("now", "now", true);
            this.assignVariable("today", "today", true);
        }
        catch (Exception e) {
            logger.error("failed to initialize some well known variables: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void removeVariable(String name) {
        this.getVariables().remove(name.toLowerCase());
    }

    @Override
    public Hashtable<Double, Double> resolveRate(String tableName, Date baseDate, double tableKey) {
        Hashtable<Double, Double> rates = new Hashtable<Double, Double>();
        rates.put(new Double(0.0), new Double(1.0));
        return rates;
    }

    @Override
    public double resolveRate(String tableId, Date effectiveDate, String key1, String key2, String key3, String key4, String key5) {
        return 1.0;
    }

    @Override
    public Object resolveVariable(String variableName) {
        return this.resolveVariable(variableName, null);
    }

    @Override
    public Object resolveVariable(String variableName, Date baseDate) {
        Variable variable = this.getVariables().get(variableName.toLowerCase());
        if (variable == null) {
            return null;
        }
        if (variable.value instanceof TokVariableWithValue) {
            return ((TokVariableWithValue)variable.value).getCurrentValue();
        }
        return variable.value;
    }

    public void setVariables(Hashtable<String, Variable> newVariables) {
        this.variables = newVariables;
    }

    static class Variable {
        boolean systemGenerated;
        Object value;
        String name;

        public Variable(String _name, Object _value) {
            this(_name, _value, false);
        }

        public Variable(String _name, Object _value, boolean sysgen) {
            this.name = _name;
            this.value = _value;
            this.systemGenerated = sysgen;
        }
    }
}

