/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.operator;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import java.text.ParseException;

public class OpFactorial
extends Operator {
    public OpFactorial(EquImpl equ) {
        super(equ);
    }

    public OpFactorial(EquImpl equ, EquPart opTok) {
        super(equ, opTok);
    }

    @Override
    public boolean multiplize(EquPart rightSide) {
        return !(rightSide instanceof Operator);
    }

    @Override
    public boolean negatize(EquPart rightSide) {
        return false;
    }

    @Override
    protected int precedence() {
        return 3;
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 1) {
            throw new Exception("missing operand for " + this.toString());
        }
        try {
            long base = values.popLong();
            if (base > 20L) {
                throw new Exception(this.toString() + "; numeric overflow");
            }
            if (base < 0L) {
                throw new Exception(this.toString() + "; negative numbers not allowed");
            }
            long factorial = 1L;
            for (int i = (int)base; i > 1; --i) {
                factorial *= (long)i;
            }
            values.push(new Long(factorial));
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "op(factorial)";
    }
}

