/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;

public class FuncStringToFloat
extends Function {
    public FuncStringToFloat(EquImpl equ) {
        super(equ);
    }

    public FuncStringToFloat(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < this.getParameterCount()) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            Object value = values.popWhatever();
            if (value instanceof String) {
                if (((String)value).trim().length() == 0) {
                    values.push(new Double(0.0));
                } else {
                    values.push(Double.parseDouble((String)value));
                }
            } else if (value instanceof Long) {
                values.push(new Double(((Long)value).longValue()));
            } else if (value instanceof Double) {
                values.push(value);
            }
        }
        catch (NumberFormatException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(toFloat)";
    }
}

