/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;
import java.util.Arrays;

public class FuncStringSubstr
extends Function {
    public FuncStringSubstr(EquImpl equ) {
        super(equ);
    }

    public FuncStringSubstr(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 3) {
            throw new Exception("requires 3 parameters " + this.toString());
        }
        if (values.size() < this.getParameterCount()) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            Double length = values.popDouble();
            Double offset = values.popDouble();
            Object target = values.popStringOrByteArray();
            if (target instanceof String) {
                values.push(((String)target).substring(offset.intValue(), offset.intValue() + length.intValue()));
            } else {
                values.push(Arrays.copyOfRange((byte[])target, offset.intValue(), offset.intValue() + length.intValue()));
            }
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(substr)";
    }
}

