/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;

public class FuncRound
extends Function {
    public FuncRound(EquImpl equ) {
        super(equ);
    }

    public FuncRound(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 2) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            double multiplier = Math.pow(10.0, values.popDouble());
            values.push(new Double((double)Math.round(values.popDouble() * multiplier) / multiplier));
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(round)";
    }
}

