/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;

public class FuncMax
extends Function {
    public FuncMax(EquImpl equ) {
        super(equ);
    }

    public FuncMax(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < this.getParameterCount()) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            Object[] value = values.ensureSameTypes(this.getParameterCount());
            if (value[0] instanceof Long) {
                long bestSoFar = (Long)value[0];
                for (int x = 1; x < value.length; ++x) {
                    bestSoFar = new Long(Math.max(bestSoFar, (Long)value[x]));
                }
                values.push(new Long(bestSoFar));
            } else if (value[0] instanceof Double) {
                double bestSoFar = (Double)value[0];
                for (int x = 1; x < value.length; ++x) {
                    bestSoFar = new Double(Math.max(bestSoFar, (Double)value[x]));
                }
                values.push(new Double(bestSoFar));
            }
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(max-" + this.getParameterCount() + ")";
    }
}

