/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math;

import com.codetaco.math.MathException;
import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.support.DefaultEquationSupport;
import com.codetaco.math.impl.support.EquationSupport;
import com.codetaco.math.impl.token.TokVariable;
import java.sql.Date;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public class Equ<T> {
    private EquImpl equImpl;

    public static <B> Builder<B> builder(Class<B> returnType) {
        return new Builder();
    }

    private Equ(EquImpl equImpl) {
        this.equImpl = equImpl;
    }

    EquImpl getEquImpl() {
        return this.equImpl;
    }

    public T evaluate() {
        Object result = this.equImpl.evaluate();
        if (result instanceof TokVariable) {
            throw MathException.builder().cause(new Exception("unresolved variable: \"" + ((TokVariable)result).getName() + "\"")).build();
        }
        return (T)result;
    }

    public void variable(String variableName, Object value) {
        try {
            this.equImpl.getSupport().assignVariable(variableName, value);
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public String getString(String variableName) {
        try {
            Object value = this.equImpl.getSupport().resolveVariable(variableName);
            if (value instanceof Double) {
                return value.toString();
            }
            if (value instanceof Integer) {
                return ((Integer)value).toString();
            }
            if (value instanceof Long) {
                return ((Long)value).toString();
            }
            return (String)value;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public String toString() {
        return this.equImpl.toString();
    }

    public Long getLong(String variableName) {
        try {
            Object value = this.equImpl.getSupport().resolveVariable(variableName);
            if (value instanceof Double) {
                return ((Double)value).longValue();
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            return (Long)value;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public Integer getInteger(String variableName) {
        try {
            Object value = this.equImpl.getSupport().resolveVariable(variableName);
            if (value instanceof Double) {
                return ((Double)value).intValue();
            }
            if (value instanceof Long) {
                return ((Long)value).intValue();
            }
            return (Integer)value;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public ZonedDateTime getZonedDateTime(String variableName) {
        try {
            Object value = this.equImpl.getSupport().resolveVariable(variableName);
            return (ZonedDateTime)value;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public Double getDouble(String variableName) {
        try {
            Object value = this.equImpl.getSupport().resolveVariable(variableName);
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            if (value instanceof Long) {
                return ((Long)value).doubleValue();
            }
            return (Double)value;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public String showRPN() {
        return this.equImpl.showRPN();
    }

    public static class Builder<B> {
        private EquationSupport support;
        private String equation;
        private Date baseDate;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private Map<String, Class> functions = new HashMap<String, Class>();

        public Builder<B> support(EquationSupport support) {
            this.support = support;
            return this;
        }

        public Builder<B> equation(String equation) {
            this.equation = equation;
            return this;
        }

        public Builder<B> variable(String variableName, Object value) {
            this.variables.put(variableName, value);
            return this;
        }

        public Builder<B> function(String functionName, Class functionClass) {
            this.functions.put(functionName.toLowerCase(), functionClass);
            return this;
        }

        public Builder<B> baseDate(Date baseDate) {
            this.baseDate = baseDate;
            return this;
        }

        public Equ<B> build() {
            EquImpl impl = new EquImpl();
            impl.initialize();
            this.functions.forEach((functionName, functionClass) -> {
                try {
                    impl.registerFunction((String)functionName, (Class<?>)functionClass);
                }
                catch (Exception e) {
                    throw MathException.builder().cause(e).build();
                }
            });
            if (this.support == null) {
                impl.setSupport(new DefaultEquationSupport());
            } else {
                impl.setSupport(this.support);
            }
            this.variables.forEach((variableName, value) -> {
                try {
                    impl.getSupport().assignVariable((String)variableName, value);
                }
                catch (Exception e) {
                    throw MathException.builder().cause(e).build();
                }
            });
            impl.setBaseDate(this.baseDate);
            impl.compile(this.equation);
            return new Equ(impl);
        }

        public B evaluate() {
            return this.build().evaluate();
        }
    }
}

