/*
 * Decompiled with CFR 0.152.
 */
package com.codesasthra.support;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class DateTimeConverter {
    private Context ctx;
    private String inputFormat;
    private String outputFormat;
    private String mDate;
    private Date date;
    private boolean returnDateObject;

    public String convert() {
        String formattedDate = "N/A";
        try {
            Locale locale = this.ctx != null ? (Build.VERSION.SDK_INT >= 24 ? this.ctx.getResources().getConfiguration().getLocales().get(0) : this.ctx.getResources().getConfiguration().locale) : new Locale("en", "US");
            if (!DateTimeConverter.is_valid(this.outputFormat)) {
                this.outputFormat = "dd MMM yyyy";
            }
            SimpleDateFormat mOutputDateFormat = new SimpleDateFormat(this.outputFormat, locale);
            if (this.date == null) {
                if (!DateTimeConverter.is_valid(this.inputFormat)) {
                    this.inputFormat = this.getInputDateTimeFormat(this.mDate);
                }
                if (DateTimeConverter.is_valid(this.inputFormat) && DateTimeConverter.is_valid(this.mDate)) {
                    SimpleDateFormat mInputDateFormat = new SimpleDateFormat(this.inputFormat, locale);
                    Date inputDate = mInputDateFormat.parse(this.mDate);
                    formattedDate = mOutputDateFormat.format(inputDate);
                } else {
                    Date inputDate = Calendar.getInstance().getTime();
                    formattedDate = mOutputDateFormat.format(inputDate);
                }
            } else {
                formattedDate = mOutputDateFormat.format(this.date);
            }
        }
        catch (Exception e) {
            Log.e((String)"ERROR", (String)"Specify the correct input/Output format for Ex : new DateTimeConverter.Builder()\n                .setDateString(\"23-07-2017\")\n                .setInputFormat(\"dd-MM-yyyy\")\n                .create();");
            e.printStackTrace();
        }
        return formattedDate;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getmDate() {
        return this.mDate;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isReturnDateObject() {
        return this.returnDateObject;
    }

    private DateTimeConverter(Builder builder) {
        this.ctx = builder.ctx;
        this.inputFormat = builder.inputFormat;
        this.outputFormat = builder.outputFormat;
        this.mDate = builder.mDate;
        this.date = builder.date;
        this.returnDateObject = builder.returnDateObject;
    }

    private static boolean is_valid(String str) {
        return str != null && !str.equalsIgnoreCase("null") && str.trim().length() != 0;
    }

    private String getInputDateTimeFormat(String mDate) {
        if (!DateTimeConverter.is_valid(mDate)) {
            return "";
        }
        if (Pattern.matches("....-..-..", mDate)) {
            return "yyyy-MM-dd";
        }
        if (Pattern.matches("..-..-....", mDate)) {
            return "dd-MM-yyyy";
        }
        if (Pattern.matches("..../../..", mDate)) {
            return "yyyy/mm/dd";
        }
        if (Pattern.matches("../../....", mDate)) {
            return "dd/MM/yyyy";
        }
        if (Pattern.matches("....-..-.. ..:..:..", mDate)) {
            return "yyyy-MM-dd kk:mm:ss";
        }
        if (Pattern.matches("../../.... ..:..:..", mDate)) {
            return "MM/dd/yyyy HH:mm:ss";
        }
        return "";
    }

    public static class Builder {
        private Context ctx;
        private String inputFormat;
        private String outputFormat;
        private String mDate;
        private Date date;
        private boolean returnDateObject;

        public Builder setReturnDateObject(boolean returnDateObject) {
            this.returnDateObject = returnDateObject;
            return this;
        }

        public Builder setLocale(Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public Builder setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        public Builder setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder setDateString(String mDate) {
            this.mDate = mDate;
            return this;
        }

        public String create() {
            DateTimeConverter dtc = new DateTimeConverter(this);
            return dtc.convert();
        }
    }
}

