/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.animation.ObjectAnimator;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.codersun.fingerprintcompat.AFingerDialog;
import com.codersun.fingerprintcompat.FingerManagerController;
import com.codersun.fingerprintcompat.R;

@RequiresApi(api=23)
public class DefaultFingerDialog
extends AFingerDialog
implements View.OnClickListener {
    private static final String TITLE = "title";
    private static final String DES = "des";
    private static final String NEGATIVE_TEXT = "negativeText";
    private FingerManagerController mFingerManagerController;
    private ObjectAnimator animator;
    private TextView titleTv;
    private TextView desTv;

    public static DefaultFingerDialog newInstance(FingerManagerController fingerManagerController) {
        DefaultFingerDialog defaultFingerDialog = new DefaultFingerDialog();
        Bundle bundle = new Bundle();
        bundle.putString(TITLE, fingerManagerController.getTitle());
        bundle.putString(DES, fingerManagerController.getDes());
        bundle.putString(NEGATIVE_TEXT, fingerManagerController.getNegativeText());
        defaultFingerDialog.setArguments(bundle);
        return defaultFingerDialog;
    }

    private DefaultFingerDialog() {
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View view = inflater.inflate(R.layout.dialog_finger, null);
        this.titleTv = (TextView)view.findViewById(R.id.finger_dialog_title_tv);
        this.desTv = (TextView)view.findViewById(R.id.finger_dialog_des_tv);
        TextView cancelTv = (TextView)view.findViewById(R.id.finger_dialog_cancel_tv);
        cancelTv.setOnClickListener((View.OnClickListener)this);
        if (this.getArguments() != null) {
            this.titleTv.setText((CharSequence)this.getArguments().getString(TITLE));
            this.desTv.setText((CharSequence)this.getArguments().getString(DES));
            cancelTv.setText((CharSequence)this.getArguments().getString(NEGATIVE_TEXT));
        }
        this.animator = ObjectAnimator.ofFloat((Object)this.desTv, (Property)View.TRANSLATION_X, (float[])new float[]{20.0f, -20.0f});
        this.animator.setRepeatCount(1);
        this.animator.setDuration(500L);
        return view;
    }

    @Override
    public void onSucceed() {
        this.dismiss();
    }

    @Override
    public void onFailed() {
        this.titleTv.setText((CharSequence)"\u8bf7\u91cd\u8bd5");
        this.desTv.setText((CharSequence)"\u6362\u4e2a\u624b\u6307\u8bd5\u8bd5");
        this.desTv.setVisibility(0);
        if (!this.animator.isRunning()) {
            this.animator.start();
        }
    }

    @Override
    public void onHelp(String help) {
        this.titleTv.setVisibility(0);
        this.desTv.setVisibility(0);
        this.titleTv.setText((CharSequence)"\u8bf7\u91cd\u8bd5");
        this.desTv.setText((CharSequence)"\u6362\u4e2a\u624b\u6307\u8bd5\u8bd5");
        if (!(TextUtils.isEmpty((CharSequence)help) || this.desTv.getText().toString().trim().equals(help.trim()) || this.animator.isRunning())) {
            this.animator.start();
        }
    }

    @Override
    public void onError(String error) {
        this.dismissAllowingStateLoss();
    }

    @Override
    public void onCancelAuth() {
    }

    public void onClick(View v) {
        this.dismiss();
    }
}

