/*
 * Decompiled with CFR 0.152.
 */
package com.coder.mario.android.widget.refresh;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.coder.mario.android.widget.refresh.INestedRefreshLoad;
import com.coder.mario.android.widget.refresh.INestedRefreshState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class NestedRefreshLayout
extends LinearLayout
implements NestedScrollingParent,
NestedScrollingChild {
    public static final int STATE_CURRENT_RESET = 0;
    public static final int STATE_CURRENT_LOADING = 1;
    public static final int STATE_RELEASE_NOTHING = 2;
    public static final int STATE_LOADING_COMPLETE = 3;
    public static final int STATE_RELEASE_TO_LOADING = 4;
    private int mState = 0;
    private INestedRefreshState mRefreshState;
    private NestedScrollingParentHelper mParentHelper;
    private NestedScrollingChildHelper mChildHelper;
    private AtomicBoolean mNestedTag = new AtomicBoolean(false);
    private ValueAnimator mBackAnimator;
    private float dyHolder;
    private int Range_Max = 520;
    private FrameLayout mHeadHolder;
    private INestedRefreshLoad mINestedRefreshLoad;
    private LoadStartListener mStartListener;
    private IdleState mIdleState;
    private WorkState mWorkState;
    private long mDuration = 1600L;
    private DurationHandler mDurationHandler;
    private List<ScrollChangeListener> mScrollChangeListenerSet;
    private float mResistance = 0.12f;

    public NestedRefreshLayout(Context context) {
        super(context);
        this.init();
    }

    public NestedRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public NestedRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setRefreshState(this.getIdleState());
        this.setOrientation(1);
        this.mHeadHolder = new FrameLayout(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.addView((View)this.mHeadHolder, layoutParams);
    }

    private INestedRefreshLoad getINestedRefreshLoad() {
        return this.mINestedRefreshLoad;
    }

    private IdleState getIdleState() {
        if (null == this.mIdleState) {
            this.mIdleState = new IdleState();
        }
        return this.mIdleState;
    }

    private WorkState getWorkState() {
        if (null == this.mWorkState) {
            this.mWorkState = new WorkState();
        }
        return this.mWorkState;
    }

    private int getState() {
        return this.mState;
    }

    private void setState(int state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        this.onStateChanged(state);
    }

    public void setRefreshLoad(INestedRefreshLoad refreshLoad) {
        this.mINestedRefreshLoad = refreshLoad;
        if (null == refreshLoad) {
            return;
        }
        int viewHeight = refreshLoad.getViewHeight();
        FrameLayout.LayoutParams layoutParams01 = new FrameLayout.LayoutParams(-1, viewHeight);
        this.mHeadHolder.addView(refreshLoad.getView(), (ViewGroup.LayoutParams)layoutParams01);
        LinearLayout.LayoutParams layoutParams02 = (LinearLayout.LayoutParams)this.mHeadHolder.getLayoutParams();
        layoutParams02.setMargins(0, 0 - refreshLoad.getViewHeight(), 0, 0);
        this.mHeadHolder.setLayoutParams((ViewGroup.LayoutParams)layoutParams02);
    }

    public final void addView(View child) {
        if (null == child) {
            throw new NullPointerException("the direct child couldn't be null");
        }
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("NestedRefreshLayout can host only one direct child");
        }
        super.addView(child);
    }

    public final void addView(View child, int index) {
        if (null == child) {
            throw new NullPointerException("the direct child couldn't been null");
        }
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("NestedRefreshLayout can host only one direct child");
        }
        super.addView(child, index);
    }

    public final void addView(View child, LinearLayout.LayoutParams params) {
        if (null == child) {
            throw new NullPointerException("the direct child couldn't been null");
        }
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("NestedRefreshLayout can host only one direct child");
        }
        super.addView(child, (ViewGroup.LayoutParams)params);
    }

    public final void addView(View child, int width, int height) {
        if (null == child) {
            throw new NullPointerException("the direct child couldn't been null");
        }
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("NestedRefreshLayout can host only one direct child");
        }
        super.addView(child, width, height);
    }

    public final void addView(View child, int index, LinearLayout.LayoutParams params) {
        if (null == child) {
            throw new NullPointerException("the direct child couldn't been null");
        }
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("NestedRefreshLayout can host only one direct child");
        }
        super.addView(child, index, (ViewGroup.LayoutParams)params);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        ValueAnimator animator;
        int action;
        int n = action = null == event ? -1 : event.getAction();
        if (0 == action && null != (animator = this.getBackAnimatorWithoutInit()) && animator.isRunning()) {
            animator.cancel();
        }
        return super.dispatchTouchEvent(event);
    }

    private NestedScrollingParentHelper getParentHelper() {
        if (null == this.mParentHelper) {
            this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        }
        return this.mParentHelper;
    }

    private NestedScrollingChildHelper getChildHelper() {
        if (null == this.mChildHelper) {
            this.mChildHelper = new NestedScrollingChildHelper((View)this);
        }
        return this.mChildHelper;
    }

    public boolean isNestedScrollingEnabled() {
        return true;
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        if (2 == nestedScrollAxes) {
            return this.getRefreshState().onStartNestedScroll(child, target);
        }
        return false;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        boolean set = this.mNestedTag.compareAndSet(false, true);
        if (set) {
            this.getDurationHandler().remove();
        }
        int scrollY = this.getScrollY();
        if (0 < dy && 0 > scrollY) {
            this.getRefreshState().onNestedPreScroll(target, dx, dy, consumed);
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (0 != Math.abs(dyUnconsumed)) {
            this.getRefreshState().onNestedScroll(target, dxUnconsumed, dyUnconsumed);
        }
    }

    public void onStopNestedScroll(View child) {
        if (!this.mNestedTag.get() || 0 == this.getScrollY()) {
            return;
        }
        int scrollY = this.getScrollY();
        this.mNestedTag.compareAndSet(true, false);
        INestedRefreshState refreshState = this.getRefreshState();
        if (null == refreshState) {
            return;
        }
        INestedRefreshLoad refreshLoad = this.getINestedRefreshLoad();
        if (null == refreshLoad) {
            refreshState.onStopNestedScroll(child, Integer.MAX_VALUE, scrollY);
        } else {
            refreshState.onStopNestedScroll(child, refreshLoad.getViewHeight(), scrollY);
        }
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (0.0f == velocityY) {
            return true;
        }
        int dir = (int)(velocityY / Math.abs(velocityY));
        return 0 > this.getScrollY() || this.canScrollVertically(dir);
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    private void setRefreshState(INestedRefreshState state) {
        this.mRefreshState = state;
        if (null == state) {
            return;
        }
        this.dyHolder = state.parse2Offset(this.getScrollY());
    }

    private INestedRefreshState getRefreshState() {
        return this.mRefreshState;
    }

    public void scrollTo(int x, int y) {
        List<ScrollChangeListener> set;
        INestedRefreshState refreshState;
        super.scrollTo(x, y);
        int scrollY = this.getScrollY();
        INestedRefreshLoad refreshLoad = this.getINestedRefreshLoad();
        if (null != refreshLoad) {
            refreshLoad.onOffsetChanged(Math.abs(scrollY));
        }
        if (null != (refreshState = this.getRefreshState())) {
            refreshState.onScrollChanged(scrollY);
        }
        if (null != (set = this.getScrollChangeListenerSet()) && 0 <= set.size()) {
            for (ScrollChangeListener listener : set) {
                if (null == listener) continue;
                listener.onScrollChanged(y);
            }
        }
    }

    private void onStateChanged(int state) {
        INestedRefreshState refreshState = this.getRefreshState();
        if (null != refreshState) {
            refreshState.onStateChanged(state);
        }
        if (1 == state) {
            this.setRefreshState(this.getWorkState());
            if (null != this.mStartListener) {
                this.mStartListener.onStart();
            }
        }
    }

    private List<ScrollChangeListener> getScrollChangeListenerSet() {
        if (null == this.mScrollChangeListenerSet) {
            this.mScrollChangeListenerSet = new ArrayList<ScrollChangeListener>();
        }
        return this.mScrollChangeListenerSet;
    }

    public void addScrollChangeListener(ScrollChangeListener listener) {
        if (null == listener || this.getScrollChangeListenerSet().contains(listener)) {
            return;
        }
        this.getScrollChangeListenerSet().add(listener);
    }

    public void removeScrollChangeListener(ScrollChangeListener listener) {
        if (null == listener || !this.getScrollChangeListenerSet().contains(listener)) {
            return;
        }
        this.getScrollChangeListenerSet().remove(listener);
    }

    public void setStartListener(LoadStartListener listener) {
        this.mStartListener = listener;
    }

    private ValueAnimator getBackAnimatorWithoutInit() {
        return this.mBackAnimator;
    }

    private void smoothScrollTo(int target) {
        int scrollY = this.getScrollY();
        ValueAnimator animator = this.getBackAnimator();
        animator.setIntValues(new int[]{scrollY, target});
        animator.setDuration(160L);
        animator.start();
    }

    private ValueAnimator getBackAnimator() {
        if (null == this.mBackAnimator) {
            this.mBackAnimator = new ValueAnimator();
            this.mBackAnimator.addListener((Animator.AnimatorListener)new InnerSmoothScrollListener());
            this.mBackAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new InnerUpdateListener());
        }
        return this.mBackAnimator;
    }

    public void completeLoad() {
        INestedRefreshState refreshState = this.getRefreshState();
        if (!(refreshState instanceof WorkState)) {
            return;
        }
        this.setState(3);
        if (!this.mNestedTag.get()) {
            this.getDurationHandler().send();
        }
    }

    private DurationHandler getDurationHandler() {
        if (null == this.mDurationHandler) {
            this.mDurationHandler = new DurationHandler();
        }
        return this.mDurationHandler;
    }

    public static interface LoadStartListener {
        public void onStart();
    }

    public static interface ScrollChangeListener {
        public void onScrollChanged(int var1);
    }

    private class DurationHandler
    extends Handler {
        private DurationHandler() {
        }

        public void send() {
            this.removeMessages(612);
            this.sendEmptyMessageDelayed(612, NestedRefreshLayout.this.mDuration);
        }

        public void remove() {
            this.removeMessages(612);
        }

        public void handleMessage(Message msg) {
            if (!NestedRefreshLayout.this.mNestedTag.get()) {
                NestedRefreshLayout.this.smoothScrollTo(0);
            }
        }
    }

    private class InnerSmoothScrollListener
    extends AnimatorListenerAdapter {
        private InnerSmoothScrollListener() {
        }

        public void onAnimationEnd(Animator animation) {
            INestedRefreshState refreshState = NestedRefreshLayout.this.getRefreshState();
            refreshState.onAnimatorEnd();
        }
    }

    private class InnerUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InnerUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            int value = (Integer)animation.getAnimatedValue();
            NestedRefreshLayout.this.scrollTo(0, value);
        }
    }

    private class WorkState
    extends BaseState {
        private WorkState() {
        }

        @Override
        public void onAnimatorEnd() {
            NestedRefreshLayout.this.dyHolder = this.parse2Offset(NestedRefreshLayout.this.getScrollY());
            int scrollY = NestedRefreshLayout.this.getScrollY();
            if (0 == scrollY && 3 == NestedRefreshLayout.this.getState()) {
                NestedRefreshLayout.this.setRefreshState(NestedRefreshLayout.this.getIdleState());
                NestedRefreshLayout.this.setState(0);
            }
        }

        @Override
        public int parse2ScrollY(float offset) {
            if (0.0f == offset) {
                return 0;
            }
            int dir = (int)(Math.abs(offset) / offset);
            offset = Math.abs(offset);
            float dyMax = (float)NestedRefreshLayout.this.Range_Max / NestedRefreshLayout.this.mResistance;
            float value = 1.0f * Math.min(offset, dyMax) / dyMax;
            float rate = (float)(1.0 - Math.pow(1.0f - value, 4.0));
            int scrollY = (int)(rate * (float)NestedRefreshLayout.this.Range_Max);
            return dir * scrollY;
        }

        @Override
        public int parse2Offset(float scrollY) {
            if (0.0f == scrollY) {
                return 0;
            }
            int dir = (int)(Math.abs(scrollY) / scrollY);
            scrollY = Math.abs(scrollY);
            float value = 1.0f - 1.0f * scrollY / (float)NestedRefreshLayout.this.Range_Max;
            float rate = (float)(1.0 - Math.sqrt(Math.sqrt(value)));
            int offset = (int)(rate * ((float)NestedRefreshLayout.this.Range_Max / NestedRefreshLayout.this.mResistance));
            return dir * offset;
        }

        @Override
        public void onStateChanged(int state) {
            if (3 != state && 0 != state) {
                return;
            }
            INestedRefreshLoad nestedRefreshLoad = NestedRefreshLayout.this.getINestedRefreshLoad();
            if (null != nestedRefreshLoad) {
                nestedRefreshLoad.onStateChanged(NestedRefreshLayout.this.getState());
            }
        }

        @Override
        public void onScrollChanged(int scrollY) {
        }

        @Override
        public void onStopNestedScroll(View child, int height, int scrollY) {
            int dir = scrollY / Math.abs(scrollY);
            int state = NestedRefreshLayout.this.getState();
            if (3 == state) {
                NestedRefreshLayout.this.smoothScrollTo(0);
                return;
            }
            INestedRefreshLoad refreshLoad = NestedRefreshLayout.this.getINestedRefreshLoad();
            if (null == refreshLoad || 0 < scrollY) {
                NestedRefreshLayout.this.smoothScrollTo(0);
                return;
            }
            if (height <= Math.abs(scrollY)) {
                height = refreshLoad.getViewHeight();
                NestedRefreshLayout.this.smoothScrollTo(dir * height);
            } else {
                NestedRefreshLayout.this.smoothScrollTo(0);
            }
        }

        @Override
        public void onNestedScroll(View target, int dx, int dy) {
            NestedRefreshLayout.this.dyHolder = NestedRefreshLayout.this.dyHolder + (float)dy;
            if (0.0f == NestedRefreshLayout.this.dyHolder) {
                NestedRefreshLayout.this.scrollTo(0, 0);
                return;
            }
            int scrollY = this.parse2ScrollY(NestedRefreshLayout.this.dyHolder);
            NestedRefreshLayout.this.scrollTo(0, scrollY);
        }

        @Override
        public boolean onStartNestedScroll(View child, View target) {
            return true;
        }

        @Override
        public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
            int scrollY = NestedRefreshLayout.this.getScrollY();
            if (scrollY + dy >= 0) {
                consumed[1] = 0 - scrollY;
                NestedRefreshLayout.this.scrollTo(0, 0);
            } else {
                consumed[1] = dy;
                this.scrollBy(consumed[1]);
            }
            NestedRefreshLayout.this.dyHolder = this.parse2Offset(NestedRefreshLayout.this.getScrollY());
        }
    }

    private class IdleState
    extends BaseState {
        private IdleState() {
        }

        @Override
        public void onAnimatorEnd() {
            int scrollY = NestedRefreshLayout.this.getScrollY();
            NestedRefreshLayout.this.dyHolder = this.parse2Offset(scrollY);
            INestedRefreshLoad refreshLoad = NestedRefreshLayout.this.getINestedRefreshLoad();
            if (null == refreshLoad) {
                return;
            }
            int height = refreshLoad.getViewHeight();
            if (0 == scrollY) {
                NestedRefreshLayout.this.setState(0);
            } else if (0 >= scrollY && height == Math.abs(scrollY)) {
                NestedRefreshLayout.this.setState(1);
            }
        }

        @Override
        public int parse2ScrollY(float offset) {
            if (0.0f == offset) {
                return 0;
            }
            int dir = (int)(Math.abs(offset) / offset);
            offset = Math.abs(offset);
            float dyMax = (float)NestedRefreshLayout.this.Range_Max / NestedRefreshLayout.this.mResistance;
            float value = 1.0f * Math.min(offset, dyMax) / dyMax;
            float rate = (float)(1.0 - Math.pow(1.0f - value, 4.0));
            int scrollY = (int)(rate * (float)NestedRefreshLayout.this.Range_Max);
            return dir * scrollY;
        }

        @Override
        public int parse2Offset(float scrollY) {
            if (0.0f == scrollY) {
                return 0;
            }
            int dir = (int)(Math.abs(scrollY) / scrollY);
            scrollY = Math.abs(scrollY);
            float value = 1.0f - 1.0f * scrollY / (float)NestedRefreshLayout.this.Range_Max;
            float rate = (float)(1.0 - Math.sqrt(Math.sqrt(value)));
            int offset = (int)(rate * ((float)NestedRefreshLayout.this.Range_Max / NestedRefreshLayout.this.mResistance));
            return dir * offset;
        }

        @Override
        public void onStateChanged(int state) {
            INestedRefreshLoad nestedRefreshLoad = NestedRefreshLayout.this.getINestedRefreshLoad();
            if (null != nestedRefreshLoad) {
                nestedRefreshLoad.onStateChanged(NestedRefreshLayout.this.getState());
            }
        }

        @Override
        public void onScrollChanged(int scrollY) {
            INestedRefreshLoad nestedRefreshLoad = NestedRefreshLayout.this.getINestedRefreshLoad();
            if (null == nestedRefreshLoad) {
                return;
            }
            int height = nestedRefreshLoad.getViewHeight();
            if (0 >= scrollY && height > Math.abs(scrollY)) {
                NestedRefreshLayout.this.setState(2);
            } else if (0 >= scrollY && height <= Math.abs(scrollY)) {
                NestedRefreshLayout.this.setState(4);
            }
        }

        @Override
        public void onStopNestedScroll(View child, int height, int scrollY) {
            int dir = scrollY / Math.abs(scrollY);
            if (height <= Math.abs(scrollY)) {
                NestedRefreshLayout.this.smoothScrollTo(dir * height);
            } else {
                NestedRefreshLayout.this.smoothScrollTo(0);
            }
        }

        @Override
        public void onNestedScroll(View target, int dx, int dy) {
            NestedRefreshLayout.this.dyHolder = NestedRefreshLayout.this.dyHolder + (float)dy;
            if (0.0f == NestedRefreshLayout.this.dyHolder) {
                NestedRefreshLayout.this.scrollTo(0, 0);
                return;
            }
            int scrollY = this.parse2ScrollY(NestedRefreshLayout.this.dyHolder);
            NestedRefreshLayout.this.scrollTo(0, scrollY);
        }

        @Override
        public boolean onStartNestedScroll(View child, View target) {
            return true;
        }

        @Override
        public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
            int scrollY = NestedRefreshLayout.this.getScrollY();
            if (scrollY + dy >= 0) {
                consumed[1] = 0 - scrollY;
                NestedRefreshLayout.this.scrollTo(0, 0);
            } else {
                consumed[1] = dy;
                this.scrollBy(consumed[1]);
            }
            NestedRefreshLayout.this.dyHolder = this.parse2Offset(NestedRefreshLayout.this.getScrollY());
        }
    }

    private abstract class BaseState
    implements INestedRefreshState {
        private BaseState() {
        }

        @Override
        public void scrollBy(int dy) {
            NestedRefreshLayout.this.scrollBy(0, dy);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

