/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class LazyDriver
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(LazyDriver.class);
    private final Config config;
    private final BrowserHealthChecker browserHealthChecker;
    private final WebDriverFactory factory;
    private final CloseDriverCommand closeDriverCommand;
    private final CreateDriverCommand createDriverCommand;
    private final Proxy userProvidedProxy;
    private final List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    private final Browser browser;
    private boolean closed;
    private WebDriver webDriver;
    @Nullable
    private SelenideProxyServer selenideProxyServer;
    @Nullable
    private DownloadsFolder browserDownloadsFolder;

    public LazyDriver(Config config, @Nullable Proxy userProvidedProxy, List<WebDriverEventListener> listeners) {
        this(config, userProvidedProxy, listeners, new WebDriverFactory(), new BrowserHealthChecker(), new CreateDriverCommand(), new CloseDriverCommand());
    }

    LazyDriver(Config config, @Nullable Proxy userProvidedProxy, List<WebDriverEventListener> listeners, WebDriverFactory factory, BrowserHealthChecker browserHealthChecker, CreateDriverCommand createDriverCommand, CloseDriverCommand closeDriverCommand) {
        this.config = config;
        this.browser = new Browser(config.browser(), config.headless());
        this.userProvidedProxy = userProvidedProxy;
        this.listeners.addAll(listeners);
        this.factory = factory;
        this.browserHealthChecker = browserHealthChecker;
        this.closeDriverCommand = closeDriverCommand;
        this.createDriverCommand = createDriverCommand;
    }

    @Override
    @Nonnull
    public Config config() {
        return this.config;
    }

    @Override
    @Nonnull
    public Browser browser() {
        return this.browser;
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.webDriver != null;
    }

    @Override
    @Nonnull
    public synchronized WebDriver getWebDriver() {
        if (this.closed) {
            throw new IllegalStateException("Webdriver has been closed. You need to call open(url) to open a browser again.");
        }
        if (this.webDriver == null) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + Thread.currentThread().getId() + ". You need to call open(url) first.");
        }
        return this.webDriver;
    }

    @Override
    @Nullable
    public SelenideProxyServer getProxy() {
        return this.selenideProxyServer;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public synchronized WebDriver getAndCheckWebDriver() {
        if (this.webDriver != null && this.config.reopenBrowserOnFail() && !this.browserHealthChecker.isBrowserStillOpen(this.webDriver)) {
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.close();
            this.createDriver();
        } else if (this.webDriver == null) {
            log.info("No webdriver is bound to current thread: {} - let's create a new webdriver", (Object)Thread.currentThread().getId());
            this.createDriver();
        }
        return this.getWebDriver();
    }

    @Override
    @CheckReturnValue
    @Nullable
    public DownloadsFolder browserDownloadsFolder() {
        return this.browserDownloadsFolder;
    }

    void createDriver() {
        CreateDriverCommand.Result result = this.createDriverCommand.createDriver(this.config, this.factory, this.userProvidedProxy, this.listeners);
        this.webDriver = result.webDriver;
        this.selenideProxyServer = result.selenideProxyServer;
        this.browserDownloadsFolder = result.browserDownloadsFolder;
        this.closed = false;
    }

    @Override
    public void close() {
        this.closeDriverCommand.close(this.config, this.webDriver, this.selenideProxyServer);
        this.webDriver = null;
        this.selenideProxyServer = null;
        this.browserDownloadsFolder = null;
        this.closed = true;
    }
}

