/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.AttributeWithValue;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Href
extends AttributeWithValue {
    public Href(String expectedAttributeValue) {
        super("href", expectedAttributeValue);
    }

    @Override
    @CheckReturnValue
    public boolean apply(Driver driver, WebElement element) {
        String href = this.getAttributeValue(element);
        String fullUrl = this.decode(href);
        return fullUrl.endsWith(this.expectedAttributeValue) || fullUrl.endsWith(this.expectedAttributeValue + "/") || href.endsWith(this.expectedAttributeValue);
    }

    String decode(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to decode " + url, e);
        }
    }
}

