/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.UploadFile;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UploadFileFromClasspath
implements Command<File> {
    UploadFile uploadFile = new UploadFile();

    @Override
    @CheckReturnValue
    @Nonnull
    public File execute(SelenideElement proxy, WebElementSource inputField, @Nullable Object[] args) throws IOException {
        String[] fileName = (String[])Util.firstOf(args);
        Object[] files = new File[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            files[i] = this.findFileInClasspath(fileName[i]);
        }
        return this.uploadFile.execute(proxy, inputField, files);
    }

    @CheckReturnValue
    @Nonnull
    protected File findFileInClasspath(String name) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + name);
        }
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

