/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Driver;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class DefaultClipboard
implements Clipboard {
    private Driver driver;

    public DefaultClipboard(Driver driver) {
        this.driver = driver;
    }

    @Override
    public String getText() {
        this.assertRemoteState();
        String content = null;
        try {
            content = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException("Can't get clipboard data! " + e.getMessage(), e);
        }
        return content;
    }

    @Override
    public void setText(String text) {
        this.assertRemoteState();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new StringSelection(text));
    }

    private void assertRemoteState() {
        if (this.driver.config().remote() != null) {
            throw new IllegalStateException("Remote driver url detected! Please use remote clipboard.");
        }
    }
}

