/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DownloadOptions;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.files.FileFilter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.internal.WrapsElement;

@ParametersAreNonnullByDefault
public interface SelenideElement
extends WebElement,
WrapsDriver,
WrapsElement,
Locatable,
TakesScreenshot {
    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement setValue(@Nullable String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement val(@Nullable String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement append(String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement pressEnter();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement pressTab();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement pressEscape();

    @CheckReturnValue
    @Nonnull
    public String getText();

    @CheckReturnValue
    @Nonnull
    public String text();

    @CheckReturnValue
    @Nonnull
    public String getOwnText();

    @CheckReturnValue
    @Nonnull
    public String innerText();

    @CheckReturnValue
    @Nonnull
    public String innerHtml();

    @CheckReturnValue
    @Nullable
    public String attr(String var1);

    @CheckReturnValue
    @Nullable
    public String name();

    @CheckReturnValue
    @Nullable
    public String val();

    @CheckReturnValue
    @Nullable
    public String getValue();

    @CheckReturnValue
    @Nonnull
    public String pseudo(String var1, String var2);

    @CheckReturnValue
    @Nonnull
    public String pseudo(String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement selectRadio(String var1);

    @CheckReturnValue
    @Nullable
    public String data(String var1);

    @Nullable
    @CheckReturnValue
    public String getAttribute(String var1);

    @Nonnull
    @CheckReturnValue
    public String getCssValue(String var1);

    @CheckReturnValue
    public boolean exists();

    @CheckReturnValue
    public boolean isDisplayed();

    @CheckReturnValue
    public boolean is(Condition var1);

    @CheckReturnValue
    public boolean has(Condition var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement setSelected(boolean var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement should(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement should(Condition var1, Duration var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldHave(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldHave(Condition var1, Duration var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldBe(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldBe(Condition var1, Duration var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNot(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNot(Condition var1, Duration var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNotHave(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNotHave(Condition var1, Duration var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNotBe(Condition ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement shouldNotBe(Condition var1, Duration var2);

    @Nonnull
    @Deprecated
    @CanIgnoreReturnValue
    public SelenideElement waitUntil(Condition var1, long var2);

    @Nonnull
    @Deprecated
    @CanIgnoreReturnValue
    public SelenideElement waitUntil(Condition var1, long var2, long var4);

    @Nonnull
    @Deprecated
    @CanIgnoreReturnValue
    public SelenideElement waitWhile(Condition var1, long var2);

    @Nonnull
    @Deprecated
    @CanIgnoreReturnValue
    public SelenideElement waitWhile(Condition var1, long var2, long var4);

    @CheckReturnValue
    @Nonnull
    public String toString();

    @CheckReturnValue
    @Nonnull
    public SelenideElement as(String var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement parent();

    @CheckReturnValue
    @Nonnull
    public SelenideElement sibling(int var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement preceding(int var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement lastChild();

    @CheckReturnValue
    @Nonnull
    public SelenideElement closest(String var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(String var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(String var1, int var2);

    @CheckReturnValue
    public SelenideElement find(By var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(By var1, int var2);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(String var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(String var1, int var2);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(By var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(By var1, int var2);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $x(String var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement $x(String var1, int var2);

    @CheckReturnValue
    @Nonnull
    public ElementsCollection findAll(String var1);

    @CheckReturnValue
    @Nonnull
    public ElementsCollection findAll(By var1);

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$(String var1);

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$(By var1);

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$x(String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public File uploadFromClasspath(String ... var1);

    @Nonnull
    @CanIgnoreReturnValue
    public File uploadFile(File ... var1);

    public void selectOption(int ... var1);

    public void selectOption(String ... var1);

    public void selectOptionContainingText(String var1);

    public void selectOptionByValue(String ... var1);

    @CheckReturnValue
    @Nonnull
    public SelenideElement getSelectedOption() throws NoSuchElementException;

    @CheckReturnValue
    @Nonnull
    public ElementsCollection getSelectedOptions();

    @CheckReturnValue
    @Nullable
    public String getSelectedValue();

    @CheckReturnValue
    @Nonnull
    public String getSelectedText();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement scrollTo();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement scrollIntoView(boolean var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement scrollIntoView(String var1);

    @CheckReturnValue
    @Nonnull
    public File download() throws FileNotFoundException;

    @CheckReturnValue
    @Nonnull
    public File download(long var1) throws FileNotFoundException;

    @CheckReturnValue
    @Nonnull
    public File download(FileFilter var1) throws FileNotFoundException;

    @CheckReturnValue
    @Nonnull
    public File download(long var1, FileFilter var3) throws FileNotFoundException;

    @CheckReturnValue
    @Nonnull
    public File download(DownloadOptions var1) throws FileNotFoundException;

    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria();

    @CheckReturnValue
    @Nonnull
    public WebElement toWebElement();

    @CheckReturnValue
    @Nonnull
    public WebElement getWrappedElement();

    public void click(ClickOptions var1);

    public void click();

    @Deprecated
    public void click(int var1, int var2);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement contextClick();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement doubleClick();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement hover();

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement dragAndDropTo(String var1);

    @Nonnull
    @CanIgnoreReturnValue
    public SelenideElement dragAndDropTo(WebElement var1);

    public <ReturnType> ReturnType execute(Command<ReturnType> var1);

    public boolean isImage();

    @CheckReturnValue
    @Nullable
    public File screenshot();

    @CheckReturnValue
    @Nullable
    public BufferedImage screenshotAsImage();
}

