/*
 * Decompiled with CFR 0.152.
 */
package com.cncoderx.wheelview;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.widget.Scroller;
import com.cncoderx.wheelview.OnWheelChangedListener;
import com.cncoderx.wheelview.WheelView;

public class WheelScroller
extends Scroller {
    private int mScrollOffset;
    private float lastTouchY;
    private boolean isScrolling;
    final WheelView mWheelView;
    private VelocityTracker mVelocityTracker;
    OnWheelChangedListener onWheelChangedListener;
    public static final int JUSTIFY_DURATION = 400;
    private int currentIndex = -1;

    public WheelScroller(Context context, WheelView wheelView) {
        super(context);
        this.mWheelView = wheelView;
    }

    public void computeScroll() {
        if (this.isScrolling) {
            this.isScrolling = this.computeScrollOffset();
            this.doScroll(this.getCurrY() - this.mScrollOffset);
            if (this.isScrolling) {
                this.mWheelView.postInvalidate();
            } else {
                this.justify();
            }
        }
    }

    private void doScroll(int distance) {
        this.mScrollOffset += distance;
        if (!this.mWheelView.isCyclic()) {
            int maxOffset = (this.mWheelView.getItemSize() - 1) * this.mWheelView.mItemHeight;
            if (this.mScrollOffset < 0) {
                this.mScrollOffset = 0;
            } else if (this.mScrollOffset > maxOffset) {
                this.mScrollOffset = maxOffset;
            }
        }
        this.notifyWheelChangedListener();
    }

    void notifyWheelChangedListener() {
        int oldValue = this.currentIndex;
        int newValue = this.getCurrentIndex();
        if (oldValue != newValue) {
            this.currentIndex = newValue;
            if (this.onWheelChangedListener != null) {
                this.onWheelChangedListener.onChanged(this.mWheelView, oldValue, newValue);
            }
        }
    }

    public int getCurrentIndex() {
        int itemHeight = this.mWheelView.mItemHeight;
        int itemSize = this.mWheelView.getItemSize();
        if (itemSize == 0) {
            return -1;
        }
        int itemIndex = this.mScrollOffset < 0 ? (this.mScrollOffset - itemHeight / 2) / itemHeight : (this.mScrollOffset + itemHeight / 2) / itemHeight;
        int currentIndex = itemIndex % itemSize;
        if (currentIndex < 0) {
            currentIndex += itemSize;
        }
        return currentIndex;
    }

    public void setCurrentIndex(int index, boolean animated) {
        int position = index * this.mWheelView.mItemHeight;
        int distance = position - this.mScrollOffset;
        if (distance == 0) {
            return;
        }
        if (animated) {
            this.isScrolling = true;
            this.startScroll(0, this.mScrollOffset, 0, distance, 400);
            this.mWheelView.invalidate();
        } else {
            this.doScroll(distance);
            this.mWheelView.invalidate();
        }
    }

    public int getItemIndex() {
        return this.mWheelView.mItemHeight == 0 ? 0 : this.mScrollOffset / this.mWheelView.mItemHeight;
    }

    public int getItemOffset() {
        return this.mWheelView.mItemHeight == 0 ? 0 : this.mScrollOffset % this.mWheelView.mItemHeight;
    }

    public void reset() {
        this.isScrolling = false;
        this.mScrollOffset = 0;
        this.notifyWheelChangedListener();
        this.forceFinished(true);
    }

    void justify() {
        int itemHeight = this.mWheelView.mItemHeight;
        int offset = this.mScrollOffset % itemHeight;
        if (offset > 0 && offset < itemHeight / 2) {
            this.isScrolling = true;
            this.startScroll(0, this.mScrollOffset, 0, -offset, 400);
            this.mWheelView.invalidate();
        } else if (offset >= itemHeight / 2) {
            this.isScrolling = true;
            this.startScroll(0, this.mScrollOffset, 0, itemHeight - offset, 400);
            this.mWheelView.invalidate();
        } else if (offset < 0 && offset > -itemHeight / 2) {
            this.isScrolling = true;
            this.startScroll(0, this.mScrollOffset, 0, -offset, 400);
            this.mWheelView.invalidate();
        } else if (offset <= -itemHeight / 2) {
            this.isScrolling = true;
            this.startScroll(0, this.mScrollOffset, 0, -itemHeight - offset, 400);
            this.mWheelView.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.lastTouchY = event.getY();
                this.forceFinished(true);
                break;
            }
            case 2: {
                float touchY = event.getY();
                int deltaY = (int)(touchY - this.lastTouchY);
                if (deltaY != 0) {
                    this.doScroll(-deltaY);
                    this.mWheelView.invalidate();
                }
                this.lastTouchY = touchY;
                break;
            }
            case 1: {
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityY = this.mVelocityTracker.getYVelocity();
                if (Math.abs(velocityY) > 0.0f) {
                    this.isScrolling = true;
                    this.fling(0, this.mScrollOffset, 0, (int)(-velocityY), 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    this.mWheelView.invalidate();
                } else {
                    this.justify();
                }
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }
}

