/*
 * Decompiled with CFR 0.152.
 */
package com.cncoderx.wheelview;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.cncoderx.wheelview.WheelView;

public class Wheel3DView
extends WheelView {
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();

    public Wheel3DView(Context context) {
        this(context, null);
    }

    public Wheel3DView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getPrefHeight() {
        int padding = this.getPaddingTop() + this.getPaddingBottom();
        int innerHeight = (int)((double)(this.mItemHeight * this.mItemCount * 2) / Math.PI);
        return innerHeight + padding;
    }

    @Override
    protected void drawItem(Canvas canvas, int index, int offset) {
        CharSequence text = this.getCharSequence(index);
        if (text == null) {
            return;
        }
        int r = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        int range = (index - this.mScroller.getItemIndex()) * this.mItemHeight - offset;
        if ((double)Math.abs(range) > (double)r * Math.PI / 2.0) {
            return;
        }
        int centerX = this.mClipRectMiddle.centerX();
        int centerY = this.mClipRectMiddle.centerY();
        double angle = (double)range / (double)r;
        float rotate = (float)Math.toDegrees(-angle);
        float translateY = (float)(Math.sin(angle) * (double)r);
        float translateZ = (float)((1.0 - Math.cos(angle)) * (double)r);
        float refractX = this.getTextSize() * 0.05f;
        int alpha = (int)(Math.cos(angle) * 255.0);
        if (range > 0 && range < this.mItemHeight) {
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(this.mClipRectMiddle);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mSelectedTextPaint);
            canvas.restore();
            this.mTextPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(this.mClipRectBottom);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range >= this.mItemHeight) {
            this.mTextPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(this.mClipRectBottom);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range < 0 && range > -this.mItemHeight) {
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(this.mClipRectMiddle);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mSelectedTextPaint);
            canvas.restore();
            this.mTextPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(this.mClipRectTop);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range <= -this.mItemHeight) {
            this.mTextPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(this.mClipRectTop);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mTextPaint);
            canvas.restore();
        } else {
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(this.mClipRectMiddle);
            this.drawText(canvas, text, centerX, centerY, 0.0f, translateY, translateZ, rotate, (Paint)this.mSelectedTextPaint);
            canvas.restore();
        }
    }

    private void drawText(Canvas canvas, CharSequence text, float centerX, float centerY, float translateX, float translateY, float translateZ, float rotateX, Paint paint) {
        this.mCamera.save();
        this.mCamera.translate(translateX, 0.0f, translateZ);
        this.mCamera.rotateX(rotateX);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        float x = centerX;
        float y = centerY + translateY;
        this.mMatrix.preTranslate(-x, -y);
        this.mMatrix.postTranslate(x, y);
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        int baseline = (int)((fontMetrics.top + fontMetrics.bottom) / 2.0f);
        canvas.concat(this.mMatrix);
        canvas.drawText(text, 0, text.length(), x, y - (float)baseline, paint);
    }
}

