/*
 * Decompiled with CFR 0.152.
 */
package com.cncoderx.wheelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.cncoderx.wheelview.OnWheelChangedListener;
import com.cncoderx.wheelview.R;
import com.cncoderx.wheelview.WheelScroller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WheelView
extends View {
    private boolean mCyclic;
    private int mVisibleItems = 9;
    private int mLineSpace = 10;
    private int mTextSize = 20;
    private int mSelectedColor;
    private int mUnselectedColor;
    private Drawable mDividerTop;
    private Drawable mDividerBottom;
    int centerX;
    int centerY;
    int upperLimit;
    int lowerLimit;
    int baseline;
    int itemWidth;
    int itemHeight;
    Paint mPaint;
    WheelScroller mScroller;
    final List<CharSequence> mEntries = new ArrayList<CharSequence>();

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelView, 0, R.style.WheelView);
        boolean cyclic = a.getBoolean(R.styleable.WheelView_cyclic, false);
        int visibleItems = a.getInt(R.styleable.WheelView_visibleItems, this.mVisibleItems);
        int lineSpace = a.getDimensionPixelOffset(R.styleable.WheelView_lineSpace, this.mLineSpace);
        int textSize = a.getDimensionPixelSize(R.styleable.WheelView_textSize, this.mTextSize);
        int selectedColor = a.getColor(R.styleable.WheelView_selectedColor, 0);
        int unselectedColor = a.getColor(R.styleable.WheelView_unselectedColor, 0);
        this.mDividerTop = a.getDrawable(R.styleable.WheelView_divider);
        this.mDividerBottom = a.getDrawable(R.styleable.WheelView_divider);
        CharSequence[] entries = a.getTextArray(R.styleable.WheelView_entries);
        a.recycle();
        this.mPaint = new TextPaint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mScroller = new WheelScroller(context, this);
        this.setCyclic(cyclic);
        this.setVisibleItems(visibleItems);
        this.setLineSpace(lineSpace);
        this.setTextSize(textSize);
        this.setSelectedColor(selectedColor);
        this.setUnselectedColor(unselectedColor);
        this.setEntries(entries);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
            this.setMeasuredDimension(widthSpecSize, heightSpecSize);
            this.mVisibleItems = this.getPrefVisibleItems();
        } else if (widthSpecMode == 0x40000000) {
            this.setMeasuredDimension(widthSpecSize, this.getPrefHeight());
        } else if (heightSpecMode == 0x40000000) {
            this.setMeasuredDimension(this.getPrefWidth(), heightSpecSize);
            this.mVisibleItems = this.getPrefVisibleItems();
        } else {
            this.setMeasuredDimension(this.getPrefWidth(), this.getPrefHeight());
        }
        this.centerX = (this.getMeasuredWidth() + this.getPaddingLeft() - this.getPaddingRight()) / 2;
        this.centerY = (this.getMeasuredHeight() + this.getPaddingTop() - this.getPaddingBottom()) / 2;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int h;
        this.upperLimit = this.centerY - this.itemHeight / 2;
        this.lowerLimit = this.centerY + this.itemHeight / 2;
        if (this.mDividerTop != null) {
            h = this.mDividerTop.getIntrinsicHeight();
            this.mDividerTop.setBounds(this.getPaddingLeft(), this.upperLimit, this.getWidth() - this.getPaddingRight(), this.upperLimit + h);
        }
        if (this.mDividerBottom != null) {
            h = this.mDividerBottom.getIntrinsicHeight();
            this.mDividerBottom.setBounds(this.getPaddingLeft(), this.lowerLimit - h, this.getWidth() - this.getPaddingRight(), this.lowerLimit);
        }
    }

    public int getPrefWidth() {
        int padding = this.getPaddingLeft() + this.getPaddingRight();
        int innerWidth = (int)((float)this.itemWidth + (float)this.mTextSize * 0.5f);
        return innerWidth + padding;
    }

    public int getPrefHeight() {
        int padding = this.getPaddingTop() + this.getPaddingBottom();
        int innerHeight = this.itemHeight * this.mVisibleItems;
        return innerHeight + padding;
    }

    public int getPrefVisibleItems() {
        int innerHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        return innerHeight / this.itemHeight;
    }

    void measureItemSize() {
        int width = 0;
        for (CharSequence cs : this.mEntries) {
            float w = Layout.getDesiredWidth((CharSequence)cs, (TextPaint)((TextPaint)this.mPaint));
            width = Math.max(width, Math.round(w));
        }
        int height = Math.round(this.mPaint.getFontMetricsInt(null) + this.mLineSpace);
        this.itemWidth = width;
        if (this.itemHeight != height) {
            this.itemHeight = height;
        }
    }

    protected void onDraw(Canvas canvas) {
        int maxIdx;
        int minIdx;
        int index = this.mScroller.getItemIndex();
        int offset = this.mScroller.getItemOffset();
        int hf = (this.mVisibleItems + 1) / 2;
        if (offset < 0) {
            minIdx = index - hf - 1;
            maxIdx = index + hf;
        } else if (offset > 0) {
            minIdx = index - hf;
            maxIdx = index + hf + 1;
        } else {
            minIdx = index - hf;
            maxIdx = index + hf;
        }
        for (int i = minIdx; i < maxIdx; ++i) {
            this.drawItem(canvas, i, offset);
        }
        if (this.mDividerTop != null) {
            this.mDividerTop.draw(canvas);
        }
        if (this.mDividerBottom != null) {
            this.mDividerBottom.draw(canvas);
        }
    }

    protected void drawItem(Canvas canvas, int index, int offset) {
        CharSequence text = this.getCharSequence(index);
        if (text == null) {
            return;
        }
        int range = (index - this.mScroller.getItemIndex()) * this.itemHeight - offset;
        int clipLeft = this.getPaddingLeft();
        int clipRight = this.getWidth() - this.getPaddingRight();
        int clipTop = this.getPaddingTop();
        int clipBottom = this.getHeight() - this.getPaddingBottom();
        if (Math.abs(range) <= 0) {
            this.mPaint.setColor(this.mSelectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
        } else if (range > 0 && range < this.itemHeight) {
            this.mPaint.setColor(this.mSelectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
            this.mPaint.setColor(this.mUnselectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, this.lowerLimit, clipRight, clipBottom);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
        } else if (range < 0 && range > -this.itemHeight) {
            this.mPaint.setColor(this.mSelectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
            this.mPaint.setColor(this.mUnselectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, this.upperLimit);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
        } else {
            this.mPaint.setColor(this.mUnselectedColor);
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
            canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY + range - this.baseline), this.mPaint);
            canvas.restore();
        }
    }

    CharSequence getCharSequence(int index) {
        int size = this.mEntries.size();
        if (size == 0) {
            return null;
        }
        CharSequence text = null;
        if (this.isCyclic()) {
            int i = index % size;
            if (i < 0) {
                i += size;
            }
            text = this.mEntries.get(i);
        } else if (index >= 0 && index < size) {
            text = this.mEntries.get(index);
        }
        return text;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mScroller.onTouchEvent(event);
    }

    public void computeScroll() {
        this.mScroller.computeScroll();
    }

    public boolean isCyclic() {
        return this.mCyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.mCyclic = cyclic;
        this.mScroller.reset();
        this.invalidate();
    }

    public int getVisibleItems() {
        return this.mVisibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        this.mVisibleItems = Math.abs(visibleItems / 2 * 2 + 1);
        this.mScroller.reset();
        this.requestLayout();
        this.invalidate();
    }

    public int getLineSpace() {
        return this.mLineSpace;
    }

    public void setLineSpace(int lineSpace) {
        this.mLineSpace = lineSpace;
        this.mScroller.reset();
        this.measureItemSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
        this.mPaint.setTextSize((float)textSize);
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        this.baseline = (int)((fontMetrics.top + fontMetrics.bottom) / 2.0f);
        this.mScroller.reset();
        this.measureItemSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
        this.invalidate();
    }

    public int getUnselectedColor() {
        return this.mUnselectedColor;
    }

    public void setUnselectedColor(int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
        this.invalidate();
    }

    public int getItemSize() {
        return this.mEntries.size();
    }

    public CharSequence getItem(int index) {
        if (index < 0 && index >= this.mEntries.size()) {
            return null;
        }
        return this.mEntries.get(index);
    }

    public CharSequence getCurrentItem() {
        return this.mEntries.get(this.getCurrentIndex());
    }

    public int getCurrentIndex() {
        return this.mScroller.getCurrentIndex();
    }

    public void setCurrentIndex(int index) {
        this.setCurrentIndex(index, false);
    }

    public void setCurrentIndex(int index, boolean animated) {
        this.mScroller.setCurrentIndex(index, animated);
    }

    public void setEntries(CharSequence ... entries) {
        this.mEntries.clear();
        if (entries != null && entries.length > 0) {
            Collections.addAll(this.mEntries, entries);
        }
        this.mScroller.reset();
        this.measureItemSize();
        this.requestLayout();
        this.invalidate();
    }

    public void setEntries(Collection<? extends CharSequence> entries) {
        this.mEntries.clear();
        if (entries != null && entries.size() > 0) {
            this.mEntries.addAll(entries);
        }
        this.mScroller.reset();
        this.measureItemSize();
        this.requestLayout();
        this.invalidate();
    }

    public OnWheelChangedListener getOnWheelChangedListener() {
        return this.mScroller.onWheelChangedListener;
    }

    public void setOnWheelChangedListener(OnWheelChangedListener onWheelChangedListener) {
        this.mScroller.onWheelChangedListener = onWheelChangedListener;
    }
}

