/*
 * Decompiled with CFR 0.152.
 */
package com.cncoderx.wheelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import com.cncoderx.wheelview.R;
import com.cncoderx.wheelview.WheelView;

public class Wheel3DView
extends WheelView {
    public static final int TOWARD_NONE = 0;
    public static final int TOWARD_LEFT = -1;
    public static final int TOWARD_RIGHT = 1;
    private int mToward;
    private Camera mCamera;
    private Matrix mMatrix;

    public Wheel3DView(Context context) {
        this(context, null);
    }

    public Wheel3DView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Wheel3DView);
        int toward = a.getInt(R.styleable.Wheel3DView_toward, 0);
        a.recycle();
        this.setToward(toward);
        this.mCamera = new Camera();
        this.mMatrix = new Matrix();
    }

    @Override
    public int getPrefWidth() {
        int prefWidth = super.getPrefWidth();
        int innerHeight = (int)((double)(this.itemHeight * this.getVisibleItems() * 2) / Math.PI);
        int towardRange = (int)(Math.sin(0.06544984694978735) * (double)innerHeight);
        return prefWidth += towardRange;
    }

    @Override
    public int getPrefHeight() {
        int padding = this.getPaddingTop() + this.getPaddingBottom();
        int innerHeight = (int)((double)(this.itemHeight * this.getVisibleItems() * 2) / Math.PI);
        return innerHeight + padding;
    }

    @Override
    protected void calcVisibleItems() {
        int innerHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int items = (int)((double)innerHeight * Math.PI / (double)this.itemHeight / 2.0);
        this.setVisibleItems(items);
    }

    float getRefractX() {
        float dx;
        switch (this.mToward) {
            case -1: {
                dx = (float)(-this.getTextSize()) * 0.07f;
                break;
            }
            case 1: {
                dx = (float)this.getTextSize() * 0.07f;
                break;
            }
            default: {
                dx = (float)this.getTextSize() * 0.05f;
            }
        }
        return dx;
    }

    @Override
    protected void drawItem(Canvas canvas, int index, int offset) {
        CharSequence text = this.getCharSequence(index);
        if (text == null) {
            return;
        }
        int r = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        int range = (index - this.mScroller.getItemIndex()) * this.itemHeight - offset;
        if ((double)Math.abs(range) > (double)r * Math.PI / 2.0) {
            return;
        }
        double angle = (double)range / (double)r;
        float rotate = (float)Math.toDegrees(-angle);
        float translateX = (float)(Math.cos(angle) * Math.sin(0.06544984694978735) * (double)r * (double)this.mToward);
        float translateY = (float)(Math.sin(angle) * (double)r);
        float scaleX = (float)Math.cos(angle / 3.0);
        float refractX = this.getRefractX();
        int clipLeft = this.getPaddingLeft();
        int clipRight = this.getWidth() - this.getPaddingRight();
        int clipTop = this.getPaddingTop();
        int clipBottom = this.getHeight() - this.getPaddingBottom();
        if (Math.abs(range) <= 0) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, translateX, translateY, rotate, 1.0f);
            canvas.restore();
        } else if (range > 0 && range < this.itemHeight) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, translateX, translateY, rotate, 1.0f);
            canvas.restore();
            this.mPaint.setColor(this.getUnselectedColor());
            canvas.save();
            canvas.clipRect(clipLeft, this.lowerLimit, clipRight, clipBottom);
            this.drawText(canvas, text, translateX, translateY, rotate, scaleX);
            canvas.restore();
        } else if (range < 0 && range > -this.itemHeight) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, translateX, translateY, rotate, 1.0f);
            canvas.restore();
            this.mPaint.setColor(this.getUnselectedColor());
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, this.upperLimit);
            this.drawText(canvas, text, translateX, translateY, rotate, scaleX);
            canvas.restore();
        } else {
            this.mPaint.setColor(this.getUnselectedColor());
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
            this.drawText(canvas, text, translateX, translateY, rotate, scaleX);
            canvas.restore();
        }
    }

    private void drawText(Canvas canvas, CharSequence text, float translateX, float translateY, float rotate, float scale) {
        this.mCamera.save();
        this.mCamera.rotateX(rotate);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        this.mMatrix.preTranslate((float)(-this.centerX), (float)(-this.centerY));
        this.mMatrix.postTranslate((float)this.centerX + translateX, (float)this.centerY + translateY);
        canvas.scale(scale, 1.0f, (float)this.centerX, (float)this.centerY);
        canvas.concat(this.mMatrix);
        canvas.drawText(text, 0, text.length(), (float)this.centerX, (float)(this.centerY - this.baseline), this.mPaint);
    }

    public int getToward() {
        return this.mToward;
    }

    public void setToward(int toward) {
        switch (toward) {
            case -1: {
                this.mToward = -1;
                break;
            }
            case 1: {
                this.mToward = 1;
                break;
            }
            default: {
                this.mToward = 0;
            }
        }
        this.requestLayout();
    }
}

