/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http5;

import com.cloudinary.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;
import org.cloudinary.json.JSONObject;

public class ApiUtils {
    public static void setTimeouts(HttpUriRequestBase request, Map<String, ? extends Object> options) {
        Integer connectTimeout;
        Integer connectionRequestTimeout;
        RequestConfig config = request.getConfig();
        RequestConfig.Builder builder = config != null ? RequestConfig.copy((RequestConfig)config) : RequestConfig.custom();
        Integer timeout = (Integer)options.get("timeout");
        if (timeout != null) {
            builder.setResponseTimeout(Timeout.ofSeconds((long)timeout.intValue()));
        }
        if ((connectionRequestTimeout = (Integer)options.get("connection_request_timeout")) != null) {
            builder.setConnectionRequestTimeout(Timeout.ofSeconds((long)connectionRequestTimeout.intValue()));
        }
        if ((connectTimeout = (Integer)options.get("connect_timeout")) != null) {
            builder.setConnectTimeout(Timeout.ofSeconds((long)connectTimeout.intValue()));
        }
        request.setConfig(builder.build());
    }

    public static List<NameValuePair> prepareParams(Map<String, ?> params) {
        ArrayList<NameValuePair> requestParams = new ArrayList<NameValuePair>();
        for (Map.Entry<String, ?> param : params.entrySet()) {
            String key = param.getKey();
            Object value = param.getValue();
            if (value instanceof Iterable) {
                for (Object single : (Iterable)value) {
                    requestParams.add((NameValuePair)new BasicNameValuePair(key + "[]", ObjectUtils.asString(single)));
                }
                continue;
            }
            if (value instanceof Map) {
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    jsonObject.put(entry.getKey().toString(), entry.getValue());
                }
                requestParams.add((NameValuePair)new BasicNameValuePair(key, jsonObject.toString()));
                continue;
            }
            requestParams.add((NameValuePair)new BasicNameValuePair(key, ObjectUtils.asString(value)));
        }
        return requestParams;
    }
}

