/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.transformation;

import com.cloudinary.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AbstractLayer<T extends AbstractLayer<T>>
implements Serializable {
    protected String resourceType = null;
    protected String type = null;
    protected String publicId = null;
    protected String format = null;

    abstract T getThis();

    public T resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this.getThis();
    }

    public T type(String type) {
        this.type = type;
        return this.getThis();
    }

    public T publicId(String publicId) {
        this.publicId = publicId.replace('/', ':');
        return this.getThis();
    }

    public T format(String format) {
        this.format = format;
        return this.getThis();
    }

    public String toString() {
        ArrayList<String> components = new ArrayList<String>();
        if (this.resourceType != null && !this.resourceType.equals("image")) {
            components.add(this.resourceType);
        }
        if (this.type != null && !this.type.equals("upload")) {
            components.add(this.type);
        }
        if (this.publicId == null) {
            throw new IllegalArgumentException("Must supply publicId");
        }
        components.add(this.formattedPublicId());
        return StringUtils.join(components, ":");
    }

    protected String formattedPublicId() {
        String transientPublicId = this.publicId;
        if (this.format != null) {
            transientPublicId = transientPublicId + "." + this.format;
        }
        return transientPublicId;
    }
}

