/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.utils.ObjectUtils;
import java.util.Date;
import org.cloudinary.json.JSONObject;

public class AccessControlRule
extends JSONObject {
    public static AccessControlRule token() {
        return new AccessControlRule(AccessType.token, null, null);
    }

    public static AccessControlRule anonymousFrom(Date start) {
        return new AccessControlRule(AccessType.anonymous, start, null);
    }

    public static AccessControlRule anonymousUntil(Date end) {
        return new AccessControlRule(AccessType.anonymous, null, end);
    }

    public static AccessControlRule anonymous(Date start, Date end) {
        return new AccessControlRule(AccessType.anonymous, start, end);
    }

    private AccessControlRule(AccessType accessType, Date start, Date end) {
        this.put("access_type", accessType.name());
        if (start != null) {
            this.put("start", ObjectUtils.toISO8601(start));
        }
        if (end != null) {
            this.put("end", ObjectUtils.toISO8601(end));
        }
    }

    public static enum AccessType {
        anonymous,
        token;

    }
}

