/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.api.signing;

import com.cloudinary.SignatureAlgorithm;
import com.cloudinary.api.signing.SignedPayloadValidator;
import com.cloudinary.utils.StringUtils;

public class NotificationRequestSignatureVerifier {
    private final SignedPayloadValidator signedPayloadValidator;

    public NotificationRequestSignatureVerifier(String secretKey) {
        this.signedPayloadValidator = new SignedPayloadValidator(secretKey, SignatureAlgorithm.SHA1);
    }

    public NotificationRequestSignatureVerifier(String secretKey, SignatureAlgorithm signatureAlgorithm) {
        this.signedPayloadValidator = new SignedPayloadValidator(secretKey, signatureAlgorithm);
    }

    public boolean verifySignature(String body, String timestamp, String signature) {
        return this.signedPayloadValidator.validateSignedPayload(StringUtils.emptyIfNull(body) + StringUtils.emptyIfNull(timestamp), signature);
    }

    public boolean verifySignature(String body, String timestamp, String signature, long secondsValidFor) {
        long parsedTimestamp;
        try {
            parsedTimestamp = Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided timestamp is not a valid number", e);
        }
        return this.verifySignature(body, timestamp, signature) && System.currentTimeMillis() - parsedTimestamp <= secondsValidFor * 1000L;
    }
}

