/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zendesk.client.v2.FixedUri;
import org.zendesk.client.v2.TemplateUri;
import org.zendesk.client.v2.Uri;
import org.zendesk.client.v2.ZendeskException;
import org.zendesk.client.v2.ZendeskResponseException;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SearchResultEntity;
import org.zendesk.client.v2.model.Status;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zendesk
implements Closeable {
    private static final String JSON = "application/json; charset=UTF-8";
    private final boolean closeClient;
    private final AsyncHttpClient client;
    private final Realm realm;
    private final String url;
    private final ObjectMapper mapper;
    private final Logger logger = LoggerFactory.getLogger(Zendesk.class);
    private boolean closed = false;
    private static final Map<String, Class<? extends SearchResultEntity>> searchResultTypes = Zendesk.searchResultTypes();

    private static Map<String, Class<? extends SearchResultEntity>> searchResultTypes() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put("ticket", Ticket.class);
        result.put("user", User.class);
        result.put("group", Group.class);
        result.put("organization", Organization.class);
        return Collections.unmodifiableMap(result);
    }

    private Zendesk(AsyncHttpClient client, String url, String username, String password) {
        this.closeClient = client == null;
        this.client = client == null ? new AsyncHttpClient() : client;
        String string = this.url = url.endsWith("/") ? url + "api/v2" : url + "/api/v2";
        if (username != null) {
            this.realm = new Realm.RealmBuilder().setScheme(Realm.AuthScheme.BASIC).setPrincipal(username).setPassword(password).setUsePreemptiveAuth(true).build();
        } else {
            if (password != null) {
                throw new IllegalStateException("Cannot specify token or password without specifying username");
            }
            this.realm = null;
        }
        this.mapper = Zendesk.createMapper();
    }

    public boolean isClosed() {
        return this.closed || this.client.isClosed();
    }

    @Override
    public void close() {
        if (this.closeClient && !this.client.isClosed()) {
            this.client.close();
        }
        this.closed = true;
    }

    public Ticket getTicket(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}.json").set("id", id)), this.handle(Ticket.class, "ticket")));
    }

    public List<Ticket> getTicketIncidents(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}/incidents.json").set("id", id)), this.handleList(Ticket.class, "tickets")));
    }

    public void deleteTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.deleteTicket(ticket.getId());
    }

    public void deleteTicket(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Ticket createTicket(Ticket ticket) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket")));
    }

    public Ticket updateTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}.json").set("id", ticket.getId()), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket")));
    }

    public void markTicketAsSpam(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.markTicketAsSpam(ticket.getId());
    }

    public void markTicketAsSpam(long id) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}/mark_as_spam.json").set("id", id)), this.handleStatus()));
    }

    public void deleteTickets(long id, long ... ids) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleStatus()));
    }

    public Iterable<Ticket> getTickets() {
        return new PagedIterable<Ticket>(this.cnst("/tickets.json"), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsByStatus(Status ... ticketStatus) {
        return new PagedIterable<Ticket>((Uri)this.tmpl("/tickets.json{?status}").set("status", Zendesk.statusArray(ticketStatus)), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsFromSearch(String searchTerm) {
        return new PagedIterable<Ticket>((Uri)this.tmpl("/search.json{?query}").set("query", searchTerm + "+type:ticket"), this.handleList(Ticket.class, "results"));
    }

    public List<Ticket> getTickets(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Ticket.class, "tickets")));
    }

    public Iterable<Ticket> getRecentTickets() {
        return new PagedIterable<Ticket>(this.cnst("/tickets/recent.json"), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getOrganizationTickets(long organizationId) {
        return new PagedIterable<Ticket>((Uri)this.tmpl("/organizations/{organizationId}/tickets.json").set("organizationId", organizationId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getUserRequestedTickets(long userId) {
        return new PagedIterable<Ticket>((Uri)this.tmpl("/users/{userId}/tickets/requested.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getUserCCDTickets(long userId) {
        return new PagedIterable<Ticket>((Uri)this.tmpl("/users/{userId}/tickets/ccd.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Audit> getTicketAudits(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudits(ticket.getId());
    }

    public Iterable<Audit> getTicketAudits(Long id) {
        return new PagedIterable<Audit>((Uri)this.tmpl("/tickets/{ticketId}/audits.json").set("ticketId", id), this.handleList(Audit.class, "audits"));
    }

    public Audit getTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        return this.getTicketAudit(ticket, (long)audit.getId());
    }

    public Audit getTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudit(ticket.getId(), id);
    }

    public Audit getTicketAudit(long ticketId, long auditId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticketId}/audits/{auditId}.json").set("ticketId", ticketId).set("auditId", auditId)), this.handle(Audit.class, "audit")));
    }

    public void trustTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.trustTicketAudit(ticket, (long)audit.getId());
    }

    public void trustTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.trustTicketAudit(ticket.getId(), id);
    }

    public void trustTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/trust.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public void makePrivateTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.makePrivateTicketAudit(ticket, (long)audit.getId());
    }

    public void makePrivateTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.makePrivateTicketAudit(ticket.getId(), id);
    }

    public void makePrivateTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/make_private.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public List<Field> getTicketFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/ticket_fields.json")), this.handleList(Field.class, "ticket_fields")));
    }

    public Field getTicketField(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handle(Field.class, "ticket_field")));
    }

    public Field createTicketField(Field field) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/ticket_fields.json"), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field")));
    }

    public Field updateTicketField(Field field) {
        Zendesk.checkHasId(field);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/ticket_fields/{id}.json").set("id", field.getId()), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field")));
    }

    public void deleteTicketField(Field field) {
        Zendesk.checkHasId(field);
        this.deleteTicket(field.getId());
    }

    public void deleteTicketField(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Attachment.Upload createUpload(String fileName, byte[] content) {
        return this.createUpload(null, fileName, "application/binary", content);
    }

    public Attachment.Upload createUpload(String fileName, String contentType, byte[] content) {
        return this.createUpload(null, fileName, contentType, content);
    }

    public Attachment.Upload createUpload(String token, String fileName, String contentType, byte[] content) {
        TemplateUri uri = this.tmpl("/uploads.json{?filename}{?token}").set("filename", fileName);
        if (token != null) {
            uri.set("token", token);
        }
        return Zendesk.complete(this.submit(this.req("POST", uri, contentType, content), this.handle(Attachment.Upload.class, "upload")));
    }

    public void deleteUpload(Attachment.Upload upload) {
        Zendesk.checkHasToken(upload);
        this.deleteUpload(upload.getToken());
    }

    public void deleteUpload(String token) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/uploads/{token}.json").set("token", token)), this.handleStatus()));
    }

    public Attachment getAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        return this.getAttachment(attachment.getId());
    }

    public Attachment getAttachment(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/attachments/{id}.json").set("id", id)), this.handle(Attachment.class, "attachment")));
    }

    public void deleteAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        this.deleteAttachment(attachment.getId());
    }

    public void deleteAttachment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/attachments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<User> getUsers() {
        return new PagedIterable<User>(this.cnst("/users.json"), this.handleList(User.class, "users"));
    }

    public Iterable<User> getGroupUsers(long id) {
        return new PagedIterable<User>((Uri)this.tmpl("/groups/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public Iterable<User> getOrganizationUsers(long id) {
        return new PagedIterable<User>((Uri)this.tmpl("/organization/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public User getUser(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}.json").set("id", id)), this.handle(User.class, "user")));
    }

    public User createUser(User user) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users.json"), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user")));
    }

    public List<User> createUsers(User ... users) {
        return this.createUsers(Arrays.asList(users));
    }

    public List<User> createUsers(List<User> users) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users/create_many.json"), JSON, this.json(Collections.singletonMap("users", users))), this.handleList(User.class, "results")));
    }

    public User updateUser(User user) {
        Zendesk.checkHasId(user);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}.json").set("id", user.getId()), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user")));
    }

    public void deleteUser(User user) {
        Zendesk.checkHasId(user);
        this.deleteUser(user.getId());
    }

    public void deleteUser(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<User> lookupUserByEmail(String email) {
        return new PagedIterable<User>((Uri)this.tmpl("/users/search.json{?query}").set("query", email), this.handleList(User.class, "users"));
    }

    public Iterable<User> lookupUserByExternalId(String externalId) {
        return new PagedIterable<User>((Uri)this.tmpl("/users/search.json{?external_id}").set("external_id", externalId), this.handleList(User.class, "users"));
    }

    public User getCurrentUser() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/users/me.json")), this.handle(User.class, "user")));
    }

    public void resetUserPassword(User user, String password) {
        Zendesk.checkHasId(user);
        this.resetUserPassword(user.getId(), password);
    }

    public void resetUserPassword(long id, String password) {
        Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/password.json").set("id", id), JSON, this.json(Collections.singletonMap("password", password))), this.handleStatus()));
    }

    public void changeUserPassword(User user, String oldPassword, String newPassword) {
        Zendesk.checkHasId(user);
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("previous_password", oldPassword);
        req.put("password", newPassword);
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}/password.json").set("id", user.getId()), JSON, this.json(req)), this.handleStatus()));
    }

    public List<Identity> getUserIdentities(User user) {
        Zendesk.checkHasId(user);
        return this.getUserIdentities(user.getId());
    }

    public List<Identity> getUserIdentities(long userId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/identities.json").set("id", userId)), this.handleList(Identity.class, "identities")));
    }

    public Identity getUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.getUserIdentity(user, (long)identity.getId());
    }

    public Identity getUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.getUserIdentity(user.getId(), identityId);
    }

    public Identity getUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handle(Identity.class, "identity")));
    }

    public List<Identity> setUserPrimaryIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.setUserPrimaryIdentity(user, (long)identity.getId());
    }

    public List<Identity> setUserPrimaryIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.setUserPrimaryIdentity(user.getId(), identityId);
    }

    public List<Identity> setUserPrimaryIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/make_primary.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handleList(Identity.class, "identities")));
    }

    public Identity verifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.verifyUserIdentity(user, (long)identity.getId());
    }

    public Identity verifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.verifyUserIdentity(user.getId(), identityId);
    }

    public Identity verifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/verify.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity")));
    }

    public Identity requestVerifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.requestVerifyUserIdentity(user, (long)identity.getId());
    }

    public Identity requestVerifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.requestVerifyUserIdentity(user.getId(), identityId);
    }

    public Identity requestVerifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/request_verification.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity")));
    }

    public void deleteUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        this.deleteUserIdentity(user, (long)identity.getId());
    }

    public void deleteUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        this.deleteUserIdentity(user.getId(), identityId);
    }

    public void deleteUserIdentity(long userId, long identityId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handleStatus()));
    }

    public void createUserIdentity(long userId, Identity identity) {
        Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", userId), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity")));
    }

    public void createUserIdentity(User user, Identity identity) {
        Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", user.getId()), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity")));
    }

    public Iterable<Request> getRequests() {
        return new PagedIterable<Request>(this.cnst("/requests.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getOpenRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/open.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getSolvedRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/solved.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getCCRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/ccd.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getUserRequests(User user) {
        Zendesk.checkHasId(user);
        return this.getUserRequests(user.getId());
    }

    public Iterable<Request> getUserRequests(long id) {
        return new PagedIterable<Request>((Uri)this.tmpl("/users/{id}/requests.json").set("id", id), this.handleList(Request.class, "requests"));
    }

    public Request getRequest(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{id}.json").set("id", id)), this.handle(Request.class, "request")));
    }

    public Request createRequest(Request request) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/requests.json"), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request")));
    }

    public Request updateRequest(Request request) {
        Zendesk.checkHasId(request);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/requests/{id}.json").set("id", request.getId()), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request")));
    }

    public Iterable<Comment> getRequestComments(Request request) {
        Zendesk.checkHasId(request);
        return this.getRequestComments(request.getId());
    }

    public Iterable<Comment> getRequestComments(long id) {
        return new PagedIterable<Comment>((Uri)this.tmpl("/requests/{id}/comments.json").set("id", id), this.handleList(Comment.class, "comments"));
    }

    public Comment getRequestComment(Request request, Comment comment) {
        Zendesk.checkHasId(comment);
        return this.getRequestComment(request, (long)comment.getId());
    }

    public Comment getRequestComment(Request request, long commentId) {
        Zendesk.checkHasId(request);
        return this.getRequestComment(request.getId(), commentId);
    }

    public Comment getRequestComment(long requestId, long commentId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{requestId}/comments/{commentId}.json").set("requestId", requestId).set("commentId", commentId)), this.handle(Comment.class, "comment")));
    }

    public Iterable<Organization> getOrganizations() {
        return new PagedIterable<Organization>(this.cnst("/organizations.json"), this.handleList(Organization.class, "organizations"));
    }

    public Iterable<Organization> getAutoCompleteOrganizations(String name) {
        if (name == null || name.length() < 2) {
            throw new IllegalArgumentException("Name must be at least 2 characters long");
        }
        return new PagedIterable<Organization>((Uri)this.tmpl("/organizations/autocomplete.json{?name}").set("name", name), this.handleList(Organization.class, "organizations"));
    }

    public Organization getOrganization(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organizations/{id}.json").set("id", id)), this.handle(Organization.class, "organization")));
    }

    public Organization createOrganization(Organization organization) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organizations.json"), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization")));
    }

    public List<Organization> createOrganizations(Organization ... organizations) {
        return this.createOrganizations(Arrays.asList(organizations));
    }

    public List<Organization> createOrganizations(List<Organization> organizations) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organizations/create_many.json"), JSON, this.json(Collections.singletonMap("organizations", organizations))), this.handleList(Organization.class, "results")));
    }

    public Organization updateOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/organizations/{id}.json").set("id", organization.getId()), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization")));
    }

    public void deleteOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        this.deleteOrganization(organization.getId());
    }

    public void deleteOrganization(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Organization> lookupOrganizationsByExternalId(String externalId) {
        if (externalId == null || externalId.length() < 2) {
            throw new IllegalArgumentException("Name must be at least 2 characters long");
        }
        return new PagedIterable<Organization>((Uri)this.tmpl("/organizations/search.json{?external_id}").set("external_id", externalId), this.handleList(Organization.class, "organizations"));
    }

    public Iterable<Group> getGroups() {
        return new PagedIterable<Group>(this.cnst("/groups.json"), this.handleList(Group.class, "groups"));
    }

    public Iterable<Group> getAssignableGroups() {
        return new PagedIterable<Group>(this.cnst("/groups/assignable.json"), this.handleList(Group.class, "groups"));
    }

    public Group getGroup(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/groups/{id}.json").set("id", id)), this.handle(Group.class, "group")));
    }

    public Group createGroup(Group group) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/groups.json"), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group")));
    }

    public List<Group> createGroups(Group ... groups) {
        return this.createGroups(Arrays.asList(groups));
    }

    public List<Group> createGroups(List<Group> groups) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/groups/create_many.json"), JSON, this.json(Collections.singletonMap("groups", groups))), this.handleList(Group.class, "results")));
    }

    public Group updateGroup(Group group) {
        Zendesk.checkHasId(group);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/groups/{id}.json").set("id", group.getId()), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group")));
    }

    public void deleteGroup(Group group) {
        Zendesk.checkHasId(group);
        this.deleteGroup(group.getId());
    }

    public void deleteGroup(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/groups/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<SearchResultEntity> getSearchResults(String query) {
        return new PagedIterable<SearchResultEntity>((Uri)this.tmpl("/search.json{?query}").set("query", query), this.handleSearchList("results"));
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query) {
        String typeName = null;
        for (Map.Entry<String, Class<? extends SearchResultEntity>> entry : searchResultTypes.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            typeName = entry.getKey();
            break;
        }
        if (typeName == null) {
            return Collections.emptyList();
        }
        return new PagedIterable((Uri)this.tmpl("/search.json{?query}").set("query", query + "+type:" + typeName), this.handleList(type, "results"));
    }

    private byte[] json(Object object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private <T> ListenableFuture<T> submit(com.ning.http.client.Request request, AsyncCompletionHandler<T> handler) {
        try {
            if (request.getStringData() != null) {
                this.logger.debug("Request {} {}\n{}", new Object[]{request.getMethod(), request.getUrl(), request.getStringData()});
            } else if (request.getByteData() != null) {
                this.logger.debug("Request {} {} {} {} bytes", new Object[]{request.getMethod(), request.getUrl(), request.getHeaders().getFirstValue("Content-type"), request.getByteData().length});
            } else {
                this.logger.debug("Request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
            }
            return this.client.executeRequest(request, handler);
        }
        catch (IOException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private com.ning.http.client.Request req(String method, Uri template) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        }
        builder.setUrl(template.toString());
        return builder.build();
    }

    private com.ning.http.client.Request req(String method, Uri template, String contentType, byte[] body) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        }
        builder.setUrl(template.toString());
        builder.addHeader("Content-type", contentType);
        builder.setBody(body);
        return builder.build();
    }

    private com.ning.http.client.Request req(String method, Uri template, int page) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        }
        builder.addQueryParameter("page", Integer.toString(page));
        builder.setUrl(template.toString().replace("%2B", "+"));
        return builder.build();
    }

    protected AsyncCompletionHandler<Void> handleStatus() {
        return new AsyncCompletionHandler<Void>(){

            public Void onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return null;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> AsyncCompletionHandler<T> handle(final Class<T> clazz) {
        return new AsyncCompletionHandler<T>(){

            public T onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return Zendesk.this.mapper.reader(clazz).readValue(response.getResponseBodyAsBytes());
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> AsyncCompletionHandler<T> handle(final Class<T> clazz, final String name) {
        return new AsyncCompletionHandler<T>(){

            public T onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return Zendesk.this.mapper.convertValue((Object)Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes()).get(name), clazz);
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> AsyncCompletionHandler<List<T>> handleList(final Class<T> clazz) {
        return new AsyncCompletionHandler<List<T>>(){

            public List<T> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (JsonNode node : Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes())) {
                        values.add(Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> AsyncCompletionHandler<List<T>> handleList(final Class<T> clazz, final String name) {
        return new AsyncCompletionHandler<List<T>>(){

            public List<T> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (JsonNode node : Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes()).get(name)) {
                        values.add(Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected AsyncCompletionHandler<List<SearchResultEntity>> handleSearchList(final String name) {
        return new AsyncCompletionHandler<List<SearchResultEntity>>(){

            public List<SearchResultEntity> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    ArrayList<SearchResultEntity> values = new ArrayList<SearchResultEntity>();
                    for (JsonNode node : Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes()).get(name)) {
                        Class clazz = (Class)searchResultTypes.get(node.get("result_type"));
                        if (clazz == null) continue;
                        values.add((SearchResultEntity)Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    private TemplateUri tmpl(String template) {
        return new TemplateUri(this.url + template);
    }

    private Uri cnst(String template) {
        return new FixedUri(this.url + template);
    }

    private void logResponse(Response response) throws IOException {
        this.logger.debug("Response HTTP/{} {}\n{}", new Object[]{response.getStatusCode(), response.getStatusText(), response.getResponseBody()});
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Response headers {}", (Object)response.getHeaders());
        }
    }

    private boolean isStatus2xx(Response response) {
        return response.getStatusCode() / 100 == 2;
    }

    private static <T> T complete(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ZendeskException) {
                throw (ZendeskException)e.getCause();
            }
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private static void checkHasId(Ticket ticket) {
        if (ticket.getId() == null) {
            throw new IllegalArgumentException("Ticket requires id");
        }
    }

    private static void checkHasId(Request request) {
        if (request.getId() == null) {
            throw new IllegalArgumentException("Request requires id");
        }
    }

    private static void checkHasId(Audit audit) {
        if (audit.getId() == null) {
            throw new IllegalArgumentException("Audit requires id");
        }
    }

    private static void checkHasId(Comment comment) {
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment requires id");
        }
    }

    private static void checkHasId(Field field) {
        if (field.getId() == null) {
            throw new IllegalArgumentException("Field requires id");
        }
    }

    private static void checkHasId(Attachment attachment) {
        if (attachment.getId() == null) {
            throw new IllegalArgumentException("Attachment requires id");
        }
    }

    private static void checkHasId(User user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User requires id");
        }
    }

    private static void checkHasId(Identity identity) {
        if (identity.getId() == null) {
            throw new IllegalArgumentException("Identity requires id");
        }
    }

    private static void checkHasId(Organization organization) {
        if (organization.getId() == null) {
            throw new IllegalArgumentException("Organization requires id");
        }
    }

    private static void checkHasId(Group group) {
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group requires id");
        }
    }

    private static void checkHasToken(Attachment.Upload upload) {
        if (upload.getToken() == null) {
            throw new IllegalArgumentException("Upload requires token");
        }
    }

    private static List<Long> idArray(long id, long ... ids) {
        ArrayList<Long> result = new ArrayList<Long>(ids.length + 1);
        result.add(id);
        for (long i : ids) {
            result.add(i);
        }
        return result;
    }

    private static List<String> statusArray(Status ... statuses) {
        ArrayList<String> result = new ArrayList<String>(statuses.length);
        for (Status s : statuses) {
            result.add(s.toString());
        }
        return result;
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static class Builder {
        private AsyncHttpClient client = null;
        private final String url;
        private String username = null;
        private String password = null;
        private String token = null;

        public Builder(String url) {
            this.url = url;
        }

        public Builder setClient(AsyncHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            if (password != null) {
                this.token = null;
            }
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            if (token != null) {
                this.password = null;
            }
            return this;
        }

        public Builder setRetry(boolean retry) {
            return this;
        }

        public Zendesk build() {
            if (this.token == null) {
                return new Zendesk(this.client, this.url, this.username, this.password);
            }
            return new Zendesk(this.client, this.url, this.username + "/token", this.token);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PagedIterable<T>
    implements Iterable<T> {
        private final Uri url;
        private final AsyncCompletionHandler<List<T>> handler;
        private final int initialPage;

        private PagedIterable(Uri url, AsyncCompletionHandler<List<T>> handler) {
            this(url, handler, 1);
        }

        private PagedIterable(Uri url, AsyncCompletionHandler<List<T>> handler, int initialPage) {
            this.handler = handler;
            this.url = url;
            this.initialPage = initialPage;
        }

        @Override
        public Iterator<T> iterator() {
            return new PagedIterator(this.initialPage);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PagedIterator
        implements Iterator<T> {
            private Iterator<T> current;
            private int page;

            private PagedIterator(int page) {
                this.page = page;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null || !this.current.hasNext()) {
                    if (this.page > 0) {
                        List values = (List)Zendesk.complete(Zendesk.this.submit(Zendesk.this.req("GET", PagedIterable.this.url, this.page++), PagedIterable.this.handler));
                        if (values.isEmpty()) {
                            this.page = -1;
                        }
                        this.current = values.iterator();
                    } else {
                        return false;
                    }
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

