/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.URIBase;
import com.cloudant.client.org.lightcouch.CouchDbClient;
import com.cloudant.client.org.lightcouch.ReplicatorDocument;
import com.cloudant.client.org.lightcouch.Response;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Replicator {
    private String replicatorDB;
    private String userCtxName;
    private String[] userCtxRoles;
    private CouchDbClient client;
    private ReplicatorDocument replicatorDoc;
    private URI dbURI;

    public Replicator(CouchDbClient client) {
        this.client = client;
        this.replicatorDoc = new ReplicatorDocument();
        this.replicatorDB = "_replicator";
        this.userCtxRoles = new String[0];
        this.dbURI = ((URIBase)new URIBase(client.getBaseUri()).path(this.replicatorDB)).build();
    }

    public Response save() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getSource(), "Source");
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getTarget(), "Target");
        if (this.userCtxName != null) {
            ReplicatorDocument.UserCtx ctx = new ReplicatorDocument.UserCtx();
            ctx.setName(this.userCtxName);
            ctx.setRoles(this.userCtxRoles);
            this.replicatorDoc.setUserCtx(ctx);
        }
        return this.client.put(this.dbURI, this.replicatorDoc, true);
    }

    public ReplicatorDocument find() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getId(), "Doc id");
        URI uri = new DatabaseURIHelper(this.dbURI).documentUri(this.replicatorDoc.getId(), this.replicatorDoc.getRevision());
        return this.client.get(uri, ReplicatorDocument.class);
    }

    public List<ReplicatorDocument> findAll() {
        ArrayList<ReplicatorDocument> arrayList;
        InputStream instream = null;
        try {
            URI uri = ((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.dbURI).path("_all_docs")).query("include_docs", "true")).build();
            instream = this.client.get(uri);
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            JsonArray jsonArray = new JsonParser().parse((Reader)reader).getAsJsonObject().getAsJsonArray("rows");
            ArrayList<ReplicatorDocument> list = new ArrayList<ReplicatorDocument>();
            for (JsonElement jsonElem : jsonArray) {
                JsonElement elem = jsonElem.getAsJsonObject().get("doc");
                if (CouchDbUtil.getAsString(elem.getAsJsonObject(), "_id").startsWith("_design")) continue;
                ReplicatorDocument rd = (ReplicatorDocument)this.client.getGson().fromJson(elem, ReplicatorDocument.class);
                list.add(rd);
            }
            arrayList = list;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return arrayList;
    }

    public Response remove() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getId(), "Doc id");
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getRevision(), "Doc rev");
        URI uri = ((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.dbURI).path(this.replicatorDoc.getId())).query("rev", this.replicatorDoc.getRevision())).build();
        return this.client.delete(uri);
    }

    public Replicator source(String source) {
        this.replicatorDoc.setSource(source);
        return this;
    }

    public Replicator target(String target) {
        this.replicatorDoc.setTarget(target);
        return this;
    }

    public Replicator continuous(boolean continuous) {
        this.replicatorDoc.setContinuous(continuous);
        return this;
    }

    public Replicator filter(String filter) {
        this.replicatorDoc.setFilter(filter);
        return this;
    }

    public Replicator queryParams(String queryParams) {
        this.replicatorDoc.setQueryParams((JsonObject)this.client.getGson().fromJson(queryParams, JsonObject.class));
        return this;
    }

    public Replicator queryParams(Map<String, Object> queryParams) {
        this.replicatorDoc.setQueryParams(this.client.getGson().toJsonTree(queryParams).getAsJsonObject());
        return this;
    }

    public Replicator docIds(String ... docIds) {
        this.replicatorDoc.setDocIds(docIds);
        return this;
    }

    public Replicator proxy(String proxy) {
        this.replicatorDoc.setProxy(proxy);
        return this;
    }

    public Replicator createTarget(Boolean createTarget) {
        this.replicatorDoc.setCreateTarget(createTarget);
        return this;
    }

    public Replicator replicatorDB(String replicatorDB) {
        this.replicatorDB = replicatorDB;
        this.dbURI = ((URIBase)new URIBase(this.client.getBaseUri()).path(replicatorDB)).build();
        return this;
    }

    public Replicator replicatorDocId(String replicatorDocId) {
        this.replicatorDoc.setId(replicatorDocId);
        return this;
    }

    public Replicator replicatorDocRev(String replicatorDocRev) {
        this.replicatorDoc.setRevision(replicatorDocRev);
        return this;
    }

    public Replicator workerProcesses(int workerProcesses) {
        this.replicatorDoc.setWorkerProcesses(workerProcesses);
        return this;
    }

    public Replicator workerBatchSize(int workerBatchSize) {
        this.replicatorDoc.setWorkerBatchSize(workerBatchSize);
        return this;
    }

    public Replicator httpConnections(int httpConnections) {
        this.replicatorDoc.setHttpConnections(httpConnections);
        return this;
    }

    public Replicator connectionTimeout(long connectionTimeout) {
        this.replicatorDoc.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public Replicator retriesPerRequest(int retriesPerRequest) {
        this.replicatorDoc.setRetriesPerRequest(retriesPerRequest);
        return this;
    }

    public Replicator userCtxName(String userCtxName) {
        this.userCtxName = userCtxName;
        return this;
    }

    public Replicator userCtxRoles(String ... userCtxRoles) {
        this.userCtxRoles = userCtxRoles;
        return this;
    }

    public Replicator sinceSeq(Integer sinceSeq) {
        this.replicatorDoc.setSinceSeq(sinceSeq);
        return this;
    }
}

