/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.util.QueryParameter;
import com.cloudant.client.internal.util.QueryParameters;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.Map;

public class ViewQueryParameters<K, V>
extends QueryParameters
implements Cloneable {
    private final CloudantClient client;
    private final Database db;
    private final String designDoc;
    private final String viewName;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Gson gson;
    private Integer rowsPerPage = null;
    @QueryParameter
    public Boolean descending = null;
    @QueryParameter
    public JsonElement endkey = null;
    @QueryParameter
    public String endkey_docid = null;
    @QueryParameter
    public Boolean group = null;
    @QueryParameter
    public Integer group_level = null;
    @QueryParameter
    public Boolean include_docs = null;
    @QueryParameter
    public Boolean inclusive_end = null;
    @QueryParameter
    public JsonElement key = null;
    @QueryParameter
    public JsonArray keys = null;
    @QueryParameter
    public Integer limit = null;
    @QueryParameter
    public Boolean reduce = null;
    @QueryParameter
    public Long skip = null;
    @QueryParameter
    public String stale = null;
    @QueryParameter
    public JsonElement startkey = null;
    @QueryParameter
    public String startkey_docid = null;

    ViewQueryParameters(ViewQueryParameters<K, V> parameters) {
        this(parameters.client, parameters.db, parameters.designDoc, parameters.viewName, parameters.keyType, parameters.valueType);
    }

    public ViewQueryParameters(CloudantClient client, Database db, String designDoc, String viewName, Class<K> keyType, Class<V> valueType) {
        this.client = client;
        this.db = db;
        this.designDoc = designDoc;
        this.viewName = viewName;
        this.keyType = keyType;
        this.valueType = valueType;
        this.gson = client.getGson();
    }

    public CloudantClient getClient() {
        return this.client;
    }

    public boolean getDescending() {
        return this.descending == null ? false : this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public K getEndkey() {
        return this.jsonToKey(this.endkey);
    }

    public void setEndKey(K endkey) {
        this.endkey = this.keyToJson(endkey);
    }

    public String getEndKeyDocId() {
        return this.endkey_docid;
    }

    public void setEndKeyDocId(String endkey_docid) {
        this.endkey_docid = endkey_docid;
    }

    public boolean getGroup() {
        return this.group == null ? false : this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public Integer getGroupLevel() {
        return this.group_level;
    }

    public void setGroupLevel(Integer group_level) {
        this.group_level = group_level;
    }

    public boolean getIncludeDocs() {
        return this.include_docs == null ? false : this.include_docs;
    }

    public void setIncludeDocs(boolean include_docs) {
        this.include_docs = include_docs;
    }

    public boolean getInclusiveEnd() {
        return this.inclusive_end == null ? true : this.inclusive_end;
    }

    public void setInclusiveEnd(boolean inclusive_end) {
        this.inclusive_end = inclusive_end;
    }

    public K[] getKeys() {
        if (this.key != null) {
            return new Object[]{this.jsonToKey(this.key)};
        }
        if (this.keys != null) {
            Object[] keysToReturn = new Object[this.keys.size()];
            int i = 0;
            for (JsonElement key : this.keys) {
                keysToReturn[i] = this.jsonToKey(key);
                ++i;
            }
            return keysToReturn;
        }
        return null;
    }

    public void setKeys(K[] keys) {
        if (keys != null) {
            if (keys.length == 1) {
                this.key = this.keyToJson(keys[0]);
            } else {
                JsonArray jsonKeys = new JsonArray();
                for (K key : keys) {
                    jsonKeys.add(this.keyToJson(key));
                }
                this.keys = jsonKeys;
            }
        }
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean getReduce() {
        return this.reduce == null ? true : this.reduce;
    }

    public void setReduce(boolean reduce) {
        this.reduce = reduce;
    }

    public Long getSkip() {
        return this.skip;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    public String getStale() {
        return this.stale;
    }

    public void setStale(String stale) {
        this.stale = stale;
    }

    public K getStartKey() {
        return this.jsonToKey(this.startkey);
    }

    public void setStartKey(K startkey) {
        this.startkey = this.keyToJson(startkey);
    }

    public String getStartKeyDocId() {
        return this.startkey_docid;
    }

    public void setStartKeyDocId(String startkey_docid) {
        this.startkey_docid = startkey_docid;
    }

    public Integer getRowsPerPage() {
        if (this.rowsPerPage == null || this.rowsPerPage <= 0) {
            return null;
        }
        return this.rowsPerPage;
    }

    public void setRowsPerPage(Integer rowsPerPage) {
        if (rowsPerPage == null || rowsPerPage < 1 || rowsPerPage > 0x7FFFFFFE) {
            throw new IllegalArgumentException(String.format("Rows per page must be between %s and %s", 1, 0x7FFFFFFE));
        }
        this.rowsPerPage = rowsPerPage;
        this.limit = rowsPerPage + 1;
    }

    HttpConnection asGetRequest() {
        DatabaseURIHelper builder = this.getViewURIBuilder();
        for (Map.Entry<String, Object> queryParameter : this.processParameters().entrySet()) {
            builder.query(queryParameter.getKey(), queryParameter.getValue());
        }
        return Http.GET((URI)builder.build());
    }

    protected DatabaseURIHelper getViewURIBuilder() {
        return (DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.db.getDBUri()).path("_design")).path(this.designDoc)).path("_view")).path(this.viewName);
    }

    JsonElement asJson() {
        Map<String, Object> parameters = this.processParameters();
        return this.gson.toJsonTree(parameters);
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    ViewQueryParameters<K, V> copy() {
        try {
            return (ViewQueryParameters)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonElement keyToJson(K key) {
        return this.gson.toJsonTree(key, this.keyType);
    }

    private K jsonToKey(JsonElement jsonKey) {
        return (K)this.gson.fromJson(jsonKey, this.keyType);
    }
}

