/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal;

import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class HierarchicalUriComponents {
    public static String encodeUriComponent(String source, String encoding, Type type) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        CouchDbUtil.assertNotEmpty(encoding, "Encoding");
        byte[] bytes = HierarchicalUriComponents.encodeBytes(source.getBytes(encoding), type);
        return new String(bytes, "US-ASCII");
    }

    private static byte[] encodeBytes(byte[] source, Type type) {
        CouchDbUtil.assertNotEmpty(source, "Source");
        CouchDbUtil.assertNotEmpty((Object)type, "Type");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        for (byte b : source) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (type.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return bos.toByteArray();
    }

    public static enum Type {
        SCHEME{

            @Override
            public boolean isAllowed(int c) {
                return this.isAlpha(c) || this.isDigit(c) || 43 == c || 45 == c || 46 == c;
            }
        }
        ,
        AUTHORITY{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c;
            }
        }
        ,
        HOST_IPV4{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c);
            }
        }
        ,
        HOST_IPV6{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 91 == c || 93 == c || 58 == c;
            }
        }
        ,
        PORT{

            @Override
            public boolean isAllowed(int c) {
                return this.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 43 == c || 38 == c || 59 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        URI{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

