/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal;

import com.cloudant.client.internal.URIBase;
import com.cloudant.client.internal.URIBaseMethods;
import com.cloudant.client.org.lightcouch.Params;
import com.google.gson.Gson;
import java.net.URI;
import java.util.Map;

public class DatabaseURIHelper
extends URIBaseMethods<DatabaseURIHelper> {
    public DatabaseURIHelper(URI uri, String dbName) {
        this.baseUri = ((URIBase)new URIBase(uri).path(dbName)).build();
    }

    public DatabaseURIHelper(URI uri) {
        this.baseUri = uri;
    }

    @Override
    public DatabaseURIHelper returnThis() {
        return this;
    }

    public URI getDatabaseUri() {
        return this.baseUri;
    }

    public String encodeId(String in) {
        return this.encodePath(in);
    }

    public URI changesUri(Map<String, Object> query) {
        Object since;
        if (query.containsKey("since") && !((since = query.get("since")) instanceof String)) {
            Gson gson = new Gson();
            query.put("since", gson.toJson(since));
        }
        return ((DatabaseURIHelper)this.path("_changes")).query(query).build();
    }

    public URI changesUri(String queryKey, Object queryValue) {
        if (queryKey.equals("since") && !(queryValue instanceof String)) {
            Gson gson = new Gson();
            queryValue = gson.toJson(queryValue);
        }
        return ((DatabaseURIHelper)((DatabaseURIHelper)this.path("_changes")).query(queryKey, queryValue)).build();
    }

    public URI bulkDocsUri() {
        return ((DatabaseURIHelper)this.path("_bulk_docs")).build();
    }

    public URI revsDiffUri() {
        return ((DatabaseURIHelper)this.path("_revs_diff")).build();
    }

    public URI documentUri(String documentId) {
        return this.documentUri(documentId, null, null);
    }

    public URI documentUri(String documentId, String revId) {
        return this.documentUri(documentId, "rev", revId);
    }

    public URI documentUri(String documentId, String key, Object value) {
        return ((DatabaseURIHelper)this.documentId(documentId).query(key, value)).build();
    }

    public URI documentUri(String documentId, Params params) {
        return this.documentId(documentId).query(params).build();
    }

    public URI attachmentUri(String documentId, String attachmentId) {
        return this.documentId(documentId).attachmentId(attachmentId).build();
    }

    public URI attachmentUri(String documentId, String revId, String attachmentId) {
        return this.documentId(documentId).revId(revId).attachmentId(attachmentId).build();
    }

    public DatabaseURIHelper attachmentId(String attachmentId) {
        this.path(attachmentId);
        return this.returnThis();
    }

    public DatabaseURIHelper documentId(String documentId) {
        this.path(documentId);
        return this.returnThis();
    }

    private DatabaseURIHelper revId(String revId) {
        this.query("rev", revId);
        return this.returnThis();
    }

    public DatabaseURIHelper query(Map<String, Object> query) {
        if (query != null && query.size() > 0) {
            for (Map.Entry<String, Object> entry : query.entrySet()) {
                this.query(entry.getKey(), entry.getValue());
            }
        }
        return this.returnThis();
    }

    public DatabaseURIHelper query(String query) {
        this.completeQuery = query;
        return this.returnThis();
    }

    public DatabaseURIHelper query(Params params) {
        this.qParams = params;
        return this.returnThis();
    }
}

