/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CouchDbProperties {
    private URL url;
    private int maxConnections = 6;
    private URL proxyURL;
    private PasswordAuthentication proxyAuthentication = null;
    private List<HttpConnectionRequestInterceptor> requestInterceptors = new ArrayList<HttpConnectionRequestInterceptor>();
    private List<HttpConnectionResponseInterceptor> responseInterceptors = new ArrayList<HttpConnectionResponseInterceptor>();

    public CouchDbProperties(URL url) {
        this.url = url;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public URL getProxyURL() {
        return this.proxyURL;
    }

    public URL getCouchDbURL() {
        return this.url;
    }

    public CouchDbProperties setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CouchDbProperties setProxyURL(URL proxyURL) {
        this.proxyURL = proxyURL;
        return this;
    }

    public List<HttpConnectionRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public CouchDbProperties addRequestInterceptors(HttpConnectionRequestInterceptor ... requestInterceptors) {
        this.requestInterceptors.addAll(Arrays.asList(requestInterceptors));
        return this;
    }

    public List<HttpConnectionResponseInterceptor> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    public CouchDbProperties addResponseInterceptors(HttpConnectionResponseInterceptor responseInterceptors) {
        this.responseInterceptors.addAll(Arrays.asList(responseInterceptors));
        return this;
    }

    public PasswordAuthentication getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public CouchDbProperties setProxyAuthentication(PasswordAuthentication authentication) {
        this.proxyAuthentication = authentication;
        return this;
    }
}

