/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.org.lightcouch.CouchDatabase;
import com.cloudant.client.org.lightcouch.CouchDbClient;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.CouchDbInfo;
import com.cloudant.client.org.lightcouch.NoDocumentException;
import com.cloudant.client.org.lightcouch.Params;
import com.cloudant.client.org.lightcouch.PreconditionFailedException;
import com.cloudant.client.org.lightcouch.Response;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

public abstract class CouchDatabaseBase {
    static final Logger log = Logger.getLogger(CouchDatabase.class.getCanonicalName());
    CouchDbClient couchDbClient;
    private String dbName;
    private URI dbUri;
    private URI clientUri;

    CouchDatabaseBase(CouchDbClient client, String name, boolean create) {
        CouchDbUtil.assertNotEmpty(name, "name");
        this.dbName = name;
        this.couchDbClient = client;
        this.clientUri = this.couchDbClient.getBaseUri();
        this.dbUri = new DatabaseURIHelper(this.clientUri, name).getDatabaseUri();
        if (create) {
            try {
                this.couchDbClient.createDB(this.dbName);
            }
            catch (PreconditionFailedException preconditionFailedException) {
                // empty catch block
            }
        }
    }

    public <T> T find(Class<T> classType, String id) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = new DatabaseURIHelper(this.dbUri).documentUri(id);
        return this.couchDbClient.get(uri, classType);
    }

    public <T> T find(Class<T> classType, String id, Params params) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = new DatabaseURIHelper(this.dbUri).documentUri(id, params);
        return this.couchDbClient.get(uri, classType);
    }

    public <T> T find(Class<T> classType, String id, String rev) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        URI uri = new DatabaseURIHelper(this.dbUri).documentUri(id, "rev", rev);
        return this.couchDbClient.get(uri, classType);
    }

    public <T> T findAny(Class<T> classType, String uri) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(uri, "uri");
        return this.couchDbClient.get(URI.create(uri), classType);
    }

    public InputStream find(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.couchDbClient.get(new DatabaseURIHelper(this.dbUri).documentUri(id));
    }

    public InputStream find(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        URI uri = new DatabaseURIHelper(this.dbUri).documentUri(id, "rev", rev);
        return this.couchDbClient.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        InputStream response = null;
        try {
            response = this.couchDbClient.head(new DatabaseURIHelper(this.dbUri).documentUri(id));
            CouchDbUtil.close(response);
        }
        catch (NoDocumentException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CouchDbUtil.close(response);
        }
        return true;
    }

    public Response save(Object object) {
        return this.couchDbClient.put(this.getDBUri(), object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Object object) {
        Response response;
        CouchDbUtil.assertNotEmpty(object, "object");
        InputStream response2 = null;
        try {
            response2 = this.couchDbClient.post(new DatabaseURIHelper(this.dbUri).getDatabaseUri(), this.getGson().toJson(object));
            response = CouchDbUtil.getResponse(response2, Response.class, this.getGson());
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    public Response update(Object object) {
        return this.couchDbClient.put(this.getDBUri(), object, false);
    }

    public Response remove(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        String rev = CouchDbUtil.getAsString(jsonObject, "_rev");
        return this.remove(id, rev);
    }

    public Response remove(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        URI uri = new DatabaseURIHelper(this.dbUri).documentUri(id, rev);
        return this.couchDbClient.delete(uri);
    }

    public List<Response> bulk(List<?> objects, boolean allOrNothing) {
        List<Response> list;
        CouchDbUtil.assertNotEmpty(objects, "objects");
        InputStream responseStream = null;
        try {
            JsonObject jsonObject = new JsonObject();
            if (allOrNothing) {
                jsonObject.addProperty("all_or_nothing", Boolean.valueOf(true));
            }
            URI uri = new DatabaseURIHelper(this.dbUri).bulkDocsUri();
            jsonObject.add("docs", this.getGson().toJsonTree(objects));
            HttpConnection connection = Http.POST((URI)uri, (String)"application/json");
            if (jsonObject.toString().length() != 0) {
                connection.setRequestBody(jsonObject.toString());
            }
            this.couchDbClient.execute(connection);
            responseStream = connection.responseAsInputStream();
            List<Response> bulkResponses = CouchDbUtil.getResponseList(responseStream, this.getGson(), DeserializationTypes.LC_RESPONSES);
            for (Response response : bulkResponses) {
                response.setStatusCode(connection.getConnection().getResponseCode());
            }
            list = bulkResponses;
        }
        catch (IOException e) {
            try {
                throw new CouchDbException("Error retrieving response input stream.", e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(responseStream);
                throw throwable;
            }
        }
        CouchDbUtil.close(responseStream);
        return list;
    }

    public InputStream getAttachment(String docId, String attachmentName, String revId) {
        URI uri = new DatabaseURIHelper(this.dbUri).attachmentUri(docId, revId, attachmentName);
        return this.getAttachment(uri);
    }

    private InputStream getAttachment(URI uri) {
        HttpConnection connection = Http.GET((URI)uri);
        this.couchDbClient.execute(connection);
        try {
            return connection.responseAsInputStream();
        }
        catch (IOException e) {
            throw new CouchDbException("Error retrieving response input stream.", e);
        }
    }

    public Response saveAttachment(InputStream in, String name, String contentType) {
        return this.saveAttachment(in, name, contentType, null, null);
    }

    public Response saveAttachment(InputStream in, String name, String contentType, String docId, String docRev) {
        CouchDbUtil.assertNotEmpty(in, "in");
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(contentType, "ContentType");
        if (docId == null) {
            docId = CouchDbUtil.generateUUID();
            CouchDbUtil.assertNull(docRev, "docRev");
        } else {
            CouchDbUtil.assertNotEmpty(docId, "docId");
            if (docRev != null) {
                CouchDbUtil.assertNotEmpty(docRev, "docRev");
            }
        }
        URI uri = new DatabaseURIHelper(this.dbUri).attachmentUri(docId, docRev, name);
        return this.couchDbClient.put(uri, in, contentType);
    }

    public Response removeAttachment(Object object, String attachmentName) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        String rev = CouchDbUtil.getAsString(jsonObject, "_rev");
        return this.removeAttachment(id, rev, attachmentName);
    }

    public Response removeAttachment(String id, String rev, String attachmentName) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        CouchDbUtil.assertNotEmpty(attachmentName, "attachmentName");
        URI uri = new DatabaseURIHelper(this.dbUri).attachmentUri(id, rev, attachmentName);
        return this.couchDbClient.delete(uri);
    }

    public String invokeUpdateHandler(String updateHandlerUri, String docId, Params params) {
        InputStream response;
        CouchDbUtil.assertNotEmpty(updateHandlerUri, "uri");
        String[] v = updateHandlerUri.split("/");
        DatabaseURIHelper uriHelper = ((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.dbUri).path("_design")).path(v[0])).path("_update")).path(v[1])).query(params);
        if (docId != null && !docId.isEmpty()) {
            URI uri = ((DatabaseURIHelper)uriHelper.path(docId)).build();
            response = this.couchDbClient.put(uri);
        } else {
            URI uri = uriHelper.build();
            response = this.couchDbClient.post(uri, null);
        }
        return CouchDbUtil.streamToString(response);
    }

    public URI getDBUri() {
        return new DatabaseURIHelper(this.dbUri).getDatabaseUri();
    }

    public CouchDbInfo info() {
        return this.couchDbClient.get(new DatabaseURIHelper(this.dbUri).getDatabaseUri(), CouchDbInfo.class);
    }

    public void compact() {
        InputStream response = null;
        try {
            response = this.couchDbClient.post(((DatabaseURIHelper)new DatabaseURIHelper(this.dbUri).path("_compact")).build(), "");
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public void ensureFullCommit() {
        InputStream response = null;
        try {
            response = this.couchDbClient.post(((DatabaseURIHelper)new DatabaseURIHelper(this.dbUri).path("_ensure_full_commit")).build(), "");
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public String getDbName() {
        return this.dbName;
    }

    private Gson getGson() {
        return this.couchDbClient.getGson();
    }
}

