/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.views.ViewMultipleRequest;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequester;
import com.cloudant.client.internal.views.ViewResponseImpl;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViewMultipleRequester<K, V>
implements ViewMultipleRequest<K, V> {
    private final List<ViewQueryParameters<K, V>> requestParameters = new ArrayList<ViewQueryParameters<K, V>>();

    @Override
    public List<ViewResponse<K, V>> getViewResponses() throws IOException {
        JsonArray queries = new JsonArray();
        ViewQueryParameters<K, V> viewQueryParameters = null;
        for (ViewQueryParameters<K, V> params : this.requestParameters) {
            if (viewQueryParameters == null) {
                viewQueryParameters = params;
            }
            queries.add(params.asJson());
        }
        JsonObject queryJson = new JsonObject();
        queryJson.add("queries", (JsonElement)queries);
        String requestBody = queryJson.toString();
        URI multiRequestUri = ((DatabaseURIHelper)viewQueryParameters.getViewURIBuilder().path("queries")).build();
        JsonObject jsonResponse = null;
        try {
            jsonResponse = this.performMultiRequest(multiRequestUri, viewQueryParameters, requestBody);
        }
        catch (CouchDbException e) {
            if (e.getStatusCode() == 500 && "badmatch".equals(e.getError())) {
                multiRequestUri = viewQueryParameters.getViewURIBuilder().build();
                jsonResponse = this.performMultiRequest(multiRequestUri, viewQueryParameters, requestBody);
            }
            throw e;
        }
        ArrayList<ViewResponse<K, V>> responses = new ArrayList<ViewResponse<K, V>>();
        JsonArray jsonResponses = jsonResponse.getAsJsonArray("results");
        if (jsonResponses != null) {
            int index = 0;
            for (ViewQueryParameters<K, V> params : this.requestParameters) {
                JsonObject response = jsonResponses.get(index).getAsJsonObject();
                responses.add(new ViewResponseImpl<K, V>(params, response, null));
                ++index;
            }
            return responses;
        }
        return Collections.emptyList();
    }

    public void add(ViewQueryParameters<K, V> viewQueryParameters) {
        this.requestParameters.add(viewQueryParameters);
    }

    private JsonObject performMultiRequest(URI multiRequestUri, ViewQueryParameters<K, V> viewQueryParameters, String body) throws CouchDbException, IOException {
        HttpConnection post = Http.POST((URI)multiRequestUri, (String)"application/json");
        post.setRequestBody(body);
        return ViewRequester.executeRequestWithResponseAsJson(viewQueryParameters, post);
    }
}

