/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.internal.views.PageMetadata;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;

class PaginationToken {
    @SerializedName(value="d")
    public Boolean descending = null;
    @SerializedName(value="e")
    public JsonElement endkey = null;
    @SerializedName(value="ei")
    public String endkey_docid = null;
    @SerializedName(value="i")
    public Boolean inclusive_end = null;
    @SerializedName(value="s")
    public JsonElement startkey = null;
    @SerializedName(value="si")
    public String startkey_docid = null;
    @SerializedName(value="n")
    long pageNumber;
    @SerializedName(value="dr")
    PageMetadata.PagingDirection direction;

    private PaginationToken(PageMetadata pageMetadata) {
        this.pageNumber = pageMetadata.pageNumber;
        this.direction = pageMetadata.direction;
        this.descending = pageMetadata.pageRequestParameters.descending;
        this.endkey = pageMetadata.pageRequestParameters.endkey;
        this.endkey_docid = pageMetadata.pageRequestParameters.endkey_docid;
        this.inclusive_end = pageMetadata.pageRequestParameters.inclusive_end;
        this.startkey = pageMetadata.pageRequestParameters.startkey;
        this.startkey_docid = pageMetadata.pageRequestParameters.startkey_docid;
    }

    static <K, V> PageMetadata<K, V> mergeTokenAndQueryParameters(String paginationToken, ViewQueryParameters<K, V> initialParameters) {
        String json = new String(Base64.decodeBase64((String)paginationToken), Charset.forName("UTF-8"));
        Gson paginationTokenGson = PaginationToken.getGsonWithKeyAdapter(initialParameters);
        PaginationToken token = (PaginationToken)paginationTokenGson.fromJson(json, PaginationToken.class);
        ViewQueryParameters<K, V> tokenPageParameters = initialParameters.copy();
        tokenPageParameters.descending = token.descending;
        tokenPageParameters.endkey = token.endkey;
        tokenPageParameters.endkey_docid = token.endkey_docid;
        tokenPageParameters.inclusive_end = token.inclusive_end;
        tokenPageParameters.startkey = token.startkey;
        tokenPageParameters.startkey_docid = token.startkey_docid;
        return new PageMetadata<K, V>(token.direction, token.pageNumber, tokenPageParameters);
    }

    static String tokenize(PageMetadata<?, ?> pageMetadata) {
        try {
            Gson g = PaginationToken.getGsonWithKeyAdapter(pageMetadata.pageRequestParameters);
            return new String(Base64.encodeBase64URLSafe((byte[])g.toJson((Object)new PaginationToken(pageMetadata)).getBytes("UTF-8")), Charset.forName("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static <K, V> Gson getGsonWithKeyAdapter(ViewQueryParameters<K, V> vqp) {
        return new GsonBuilder().registerTypeAdapter(vqp.getKeyType(), (Object)vqp.getClient().getGson().getAdapter(vqp.getKeyType())).create();
    }
}

