/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.util;

import com.cloudant.client.internal.util.Parameter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ParameterAnnotationProcessor {
    protected Map<String, Object> processParameters(Parameter.Type type) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Field field : this.getClass().getFields()) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null || !parameter.type().equals((Object)type)) continue;
            String parameterName = "BodyParameter.USE_FIELD_NAME".equals(parameter.value()) ? field.getName() : parameter.value();
            Object parameterValue = null;
            try {
                parameterValue = field.get(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("A field annotated with @Parameter did not have the public modifier and as such was not accessible", e);
            }
            if (parameterName == null || parameterValue == null) continue;
            parameters.put(parameterName, parameterValue);
        }
        return parameters;
    }
}

